% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixbino.R
\name{mixbino}
\alias{mixbino}
\title{Nonparametric Mixture of Binomial Regression with a Degenerate Component}
\usage{
mixbino(tg, t, x, N, tune = NULL, acc1 = NULL)
}
\arguments{
\item{tg}{the grid points on which we want to evaluate the function w(t) and p(t).}

\item{t}{the time variable associated with x.}

\item{x}{the integer observation.}

\item{N}{the number of experiments for Binomial distribution.}

\item{tune}{the bandwidth will be h*tune. Default will be 1.}

\item{acc1}{stopping criteria}
}
\value{
w contains the estimate of first component proportion function
pt is the estimate of component probability function for the first component
}
\description{
Fits the nonparametric mixture of binomial distribution with one degenerate component
\cr \eqn{w(t)*B(N,p(t))+(1-w(t))*B(N,0)}
}
\examples{
n=100;tg=seq(from=0,to=1,length.out=50);t=seq(from=0,to=1,length.out=n);
pt=0.5*(1-cos(2*pi*t));
b=rbinom(n,1,0.2);
y=numeric();
for(i in 1:n){
 if(b[i]==1){
  y[i]=0;
  }else{
      y[i]=rbinom(1,7,pt[i]);
        }
        }
 ft=mixbino(tg,t,y,7);
 mean(ft$w)
 p=0.5*(1-cos(2*pi*tg));
}
