% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixregression.R
\name{RM2_mixreg}
\alias{RM2_mixreg}
\title{Robust Mixture Regression with Thresholding-Embedded EM Algorithm for Penalized Estimation}
\usage{
RM2_mixreg(
  y,
  x,
  ininum = 20,
  pi0 = NULL,
  beta0 = NULL,
  sig0 = NULL,
  gamma0 = NULL,
  method = c("HARD", "SOFT")[1],
  cont = 0.001,
  lambda,
  m = 2,
  runnum1 = 50,
  runnum2 = 10,
  outer.conv = 0.01,
  inner.conv = 0.01
)
}
\arguments{
\item{y}{response variable vector}

\item{x}{explanatory variables matrix with rows for each observation}

\item{ininum}{number of random initial values used if initial value is not specified, default is 20}

\item{pi0}{initial value vector for proportion}

\item{beta0}{initial value matrix for beta, each row for each component.}

\item{sig0}{initial value vector for sigma}

\item{gamma0}{initial value for gamma the mean shift vector}

\item{method}{which threshold to use. Options are "HARD" and "SOFT", default is "HARD"}

\item{cont}{cutoff for minimum and maximum component sigma ratio. default is 0.001}

\item{lambda}{tuning parameter in penalty term}

\item{m}{number of components of mixture model, default is 2}

\item{runnum1}{maximum number of iteration for E step, default is 50}

\item{runnum2}{maximum number of iteration for M step, default is 10}

\item{outer.conv}{converging criteria for E step, default is 10^-2}

\item{inner.conv}{converging criteria for M step, default is 10^-2}
}
\value{
pi: estimated proportion
beta: estimated regression coefficient beta
sigma: estimated sigma for components
gamma: estimated mean shift vectors
pij: posterior probability
run: total iterations
}
\description{
Robust Mixture Regression with Thresholding-Embedded EM Algorithm for Penalized Estimation
}
\examples{
library(fpc)
data('tonedata')
y=tonedata$tuned
x=tonedata$stretchratio
k=160;x[151:k]=0;y[151:k]=5
\donttest{est_RM2=RM2_mixreg(y,x,lambda=1, ininum=1, runnum1=1, runnum2=1)}
}
