% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy.R
\name{energy}
\alias{energy}
\title{E-Statistic Test for Multivariate Normality (Energy Test)}
\usage{
energy(data, R = 1000, seed = 123)
}
\arguments{
\item{data}{A numeric matrix or data frame with observations in rows and variables in columns.}

\item{R}{Integer; number of bootstrap replicates to estimate the null distribution. Default is 1000.}

\item{seed}{Optional integer to set the random seed for reproducibility.}
}
\value{
A data frame with one row containing the following columns:
\code{Test}, the name of the test ("E-Statistic");
\code{Statistic}, the observed E-statistic;
and \code{p.value}, the p-value obtained from the bootstrap procedure.
}
\description{
Performs the E-statistic test for multivariate normality using a parametric bootstrap
to estimate the null distribution of the test statistic.
}
\examples{
\dontrun{
data <- iris[1:50, 1:4]
energy_result <- energy(data, R = 500)
energy_result
}

}
