% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn_MICE.R
\name{popdynOneMICE}
\alias{popdynOneMICE}
\title{Population dynamics for a MICE model (single year)}
\usage{
popdynOneMICE(
  np,
  nf,
  nareas,
  maxage,
  Ncur,
  Vcur,
  FMretx,
  FMx,
  PerrYrp,
  hsx,
  aRx,
  bRx,
  movy,
  Spat_targ,
  SRrelx,
  M_agecur,
  Mat_agecur,
  Fec_agecur,
  Asizex,
  Kx,
  Linfx,
  t0x,
  Mx,
  R0x,
  R0ax,
  SSBpRx,
  ax,
  bx,
  Rel,
  SexPars,
  x,
  plusgroup,
  SSB0x,
  Len_age,
  Wt_age
)
}
\arguments{
\item{np}{Integer, the number of stocks}

\item{nf}{Integer, number of fleets}

\item{maxage}{Integer, maximum modelled age}

\item{Ncur}{Array \verb{[stock, age, area]} of stock numbers}

\item{Vcur}{Array \verb{[fleet, age, area]} of the vulnerability curve}

\item{FMretx}{Array \verb{[stock, fleet, age, area]} of the retention curve}

\item{FMx}{Array \verb{[stock, fleet, age, area]} fishing mortality rate}

\item{PerrYrp}{Vector \verb{[stock]} process error - the lognormal factor for
recruitment strength}

\item{hsx}{Vector \verb{[stock]} steepness of the stock recruitment curve}

\item{aRx}{Vector \verb{[stock]} stock recruitment parameter alpha (for Ricker curve)}

\item{bRx}{Vector \verb{[stock]} stock recruitment parameter beta (for Ricker curve)}

\item{movy}{Array \verb{[stock,age,area,area]} of movement transitions}

\item{Spat_targ}{Matrix \verb{[stock, fleet]} of spatial targeting parameter
(0 evenly spatial distributed, 1 proportional to vulnerable biomass)}

\item{SRrelx}{Integer vector \verb{[stock]} the form of the stock recruitment
relationship (1 = Beverton-Holt, 2= Ricker)}

\item{M_agecur}{Matrix \verb{[stock, age]} of Natural mortality rate at age}

\item{Mat_agecur}{Matrix \verb{[stock, age]} of maturity (spawning fraction) at age}

\item{Fec_agecur}{Matrix \verb{[stock, age]} of spawning weight (fecundity) at age}

\item{Asizex}{Matrix \verb{[stock, area]} of relative area sizes}

\item{Kx}{Vector \verb{[stock]} of von B growth parameter K}

\item{Mx}{Vector \verb{[stock]} mature natural mortality rate}

\item{R0x}{Vector \verb{[stock]} unfished recruitment}

\item{R0ax}{Matrix \verb{[stock, area]} unfished recruitment by area}

\item{SSBpRx}{Matrix \verb{[stock, area]} spawning biomass per recruit by area}

\item{ax}{Vector \verb{[stock]} weight-length parameter a W=aL^b}

\item{bx}{Vector \verb{[stock]} weight-length parameter b W=aL^b}

\item{Rel}{A list of inter-stock relationships see slot Rel of MOM object class}

\item{SexPars}{A list of sex-specific relationships (SSBfrom, stock_age)}

\item{x}{Integer. The simulation number}

\item{plusgroup}{Numeric vector. Use plus-group (1) or not (0)}

\item{SSB0x}{Unfished SSB0, Vector nstock length.}

\item{Len_age}{Length-at-age this year}

\item{Wt_age}{Weight-at-age this year}

\item{nyears}{Integer, number of historical years (unfished til today)}

\item{Linf}{Vector \verb{[stock]} of von B asymptotic length parameter Linf}

\item{t0}{Vector \verb{[stock]} of von B theoretical age at zero length (t0)}
}
\description{
Completes a single iteration of recruitment, mortality, fishing and
movement given MICE model inputs
}
\author{
T.Carruthers
}
\keyword{internal}
