% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSCAM2OM.R
\name{iSCAM}
\alias{iSCAM}
\alias{load.iscam.files}
\alias{fetch.file.names}
\alias{read.report.file}
\alias{read.data.file}
\alias{read.control.file}
\alias{read.projection.file}
\alias{read.par.file}
\alias{read.mcmc}
\title{Reads iSCAM files into a hierarchical R list object}
\usage{
load.iscam.files(model.dir, burnin = 1000, thin = 1, verbose = FALSE)

fetch.file.names(path, filename)

read.report.file(fn)

read.data.file(file = NULL, verbose = FALSE)

read.control.file(
  file = NULL,
  num.gears = NULL,
  num.age.gears = NULL,
  verbose = FALSE
)

read.projection.file(file = NULL, verbose = FALSE)

read.par.file(file = NULL, verbose = FALSE)

read.mcmc(model.dir = NULL, verbose = TRUE)
}
\arguments{
\item{model.dir}{Folder name}

\item{burnin}{The initial mcmc samples to be discarded}

\item{thin}{The degree of chain thinning 1 in every thin
iterations is kept}

\item{verbose}{should detailed results be printed to console}

\item{path}{File path}

\item{filename}{The filename}

\item{fn}{File location}

\item{file}{File location}

\item{num.gears}{The number of gears}

\item{num.age.gears}{The number age-gears}
}
\description{
Internal functions for reading iSCAM input and output files
into R
}
\section{Functions}{
\itemize{
\item \code{load.iscam.files}: Wrapper function to generate R list

\item \code{fetch.file.names}: A function for returning the three types of iSCAM input and output files

\item \code{read.report.file}: A function for returning the results of the .rep iscam file

\item \code{read.data.file}: A function for returning the results of the .dat iscam file

\item \code{read.control.file}: A function for returning the results of the iscam control file

\item \code{read.projection.file}: A function for returning the results of the iscam projection file

\item \code{read.par.file}: A function for returning the results of the iscam .par file

\item \code{read.mcmc}: A function for returning the results of the iscam mcmc files
}}

\seealso{
\link{iSCAM2OM}
}
\author{
Chris Grandin (DFO PBS)
}
