# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Covariance
#' 
#' Calculates the correlation between two matrices.
#' 
#' @param A NxP matrix.
#' @param B NxQ matrix.
#' @param corMat Return correlation matrix? If false, returns a covariance matrix.
#' @return Numeric matrix. 
matCov <- function(A, B, corMat = FALSE) {
    .Call(`_MGMM_matCov`, A, B, corMat)
}

#' Eigenvalues of Symmetric Matrix. 
#' 
#' Calculates the eigenvalues of a symmetric matrix. 
#' 
#' @param A symmetric matrix. 
#' @return Numeric vector.
eigSym <- function(A) {
    .Call(`_MGMM_eigSym`, A)
}

#' Matrix Determinant
#'
#' Calculates the determinant of \eqn{A}.
#'
#' @param A Numeric matrix.
#' @param logDet Return the logarithm of the determinant? 
#' @return Scalar. 
matDet <- function(A, logDet = FALSE) {
    .Call(`_MGMM_matDet`, A, logDet)
}

#' Matrix Inverse
#' 
#' Calcualtes \eqn{A^{-1}}.
#'
#' @param A Numeric matrix.
#' @return Numeric matrix. 
matInv <- function(A) {
    .Call(`_MGMM_matInv`, A)
}

#' Matrix Inner Product
#'
#' Calculates the product \eqn{A'B}.
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix.
matIP <- function(A, B) {
    .Call(`_MGMM_matIP`, A, B)
}

#' Matrix Matrix Product
#'
#' Calculates the product \eqn{AB}. 
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix.
MMP <- function(A, B) {
    .Call(`_MGMM_MMP`, A, B)
}

#' Matrix Outer Product
#' 
#' Calculates the outer product \eqn{AB'}.
#' 
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix.
matOP <- function(A, B) {
    .Call(`_MGMM_matOP`, A, B)
}

#' Quadratic Form
#' 
#' Calculates the quadratic form \eqn{X'AX}.
#' 
#' @param X Numeric matrix.
#' @param A Numeric matrix.
#' @return Numeric matrix.
matQF <- function(X, A) {
    .Call(`_MGMM_matQF`, X, A)
}

#' Schur complement
#'
#' Calculates the efficient information \eqn{I_{bb}-I_{ba}I_{aa}^{-1}I_{ab}}. 
#'
#' @param Ibb Information of target parameter
#' @param Iaa Information of nuisance parameter
#' @param Iba Cross information between target and nuisance parameters
#' @return Numeric matrix. 
SchurC <- function(Ibb, Iaa, Iba) {
    .Call(`_MGMM_SchurC`, Ibb, Iaa, Iba)
}

#' Matrix Trace
#'
#' Calculates the trace of a matrix \eqn{A}.
#'
#' @param A Numeric matrix.
#' @return Scalar.
tr <- function(A) {
    .Call(`_MGMM_tr`, A)
}

