% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_DROPLET_07_ADHOC_PLOT_PCA_3_PlotValues_Gene.R
\name{PlotValues.PCA.Gene.10x}
\alias{PlotValues.PCA.Gene.10x}
\title{Annotate reduced dimension space with gene expression values}
\usage{
PlotValues.PCA.Gene.10x(
  MarvelObject,
  cell.ids = NULL,
  gene_short_name,
  log2.transform = TRUE,
  point.size = 0.1,
  color.gradient = c("grey90", "blue", "red"),
  type
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CheckAlignment.10x} function.}

\item{cell.ids}{Vector of character strings. Specify specific cells to plot.}

\item{gene_short_name}{Character string. Gene name whose expression will be plotting.}

\item{log2.transform}{Logical value. If set to \code{TRUE} (default), normalised gene expression values will be off-set by 1 and then log2-transformed prior to analysis.}

\item{point.size}{Numeric value. Size of data points. Default is \code{1}.}

\item{color.gradient}{Vector of character strings. Colors to indicate low, moderate, and high expression. Default is \code{c("grey90","blue","red")}.}

\item{type}{Character string. Type of reduced dimension space. Options are \code{"umap"} and \code{"tsne"}.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$adhocPlot$PCA$Gene}.
}
\description{
Annotates reduced dimension space, e.g., UMAP and tSNE, with gene expression values. Values will be automatically be log2-transformed prior to plotting.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# Define cell groups
    # Retrieve sample metadata
    sample.metadata <- marvel.demo.10x$sample.metadata

    # iPSC
    index <- which(sample.metadata$cell.type=="iPSC")
    cell.ids.1 <- sample.metadata[index, "cell.id"]
    length(cell.ids.1)

    # Cardio day 10
    index <- which(sample.metadata$cell.type=="Cardio day 10")
    cell.ids.2 <- sample.metadata[index, "cell.id"]
    length(cell.ids.2)

    # Save into list
    cell.group.list <- list("iPSC"=cell.ids.1,
                            "Cardio d10"=cell.ids.2
                            )

# Plot expression
marvel.demo.10x <- PlotValues.PCA.Gene.10x(
                      MarvelObject=marvel.demo.10x,
                      gene_short_name="TPM2",
                      color.gradient=c("grey","cyan","green","yellow","red"),
                      type="tsne"
                      )

# Check output
marvel.demo.10x$adhocPlot$PCA$Gene
}
