% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{LocalControlNearestNeighborsConfidence}
\alias{LocalControlNearestNeighborsConfidence}
\title{Provides a bootstrapped confidence interval estimate for LocalControl LTDs.}
\usage{
LocalControlNearestNeighborsConfidence(data, nBootstrap, randSeed,
  treatmentColName, treatmentCode = "", outcomeColName, clusterVars,
  labelColName = "", numThreads = 1, radiusLevels = numeric(),
  radStepType = "exp", radDecayRate = 0.8, radMinFract = 0.01,
  normalize = TRUE, verbose = FALSE)
}
\arguments{
\item{data}{DataFrame containing all variables which will be used for the analysis.}

\item{nBootstrap}{The number of times to resample and run LocalControl for the confidence intervals.}

\item{randSeed}{The seed used to set random number generator state prior to resampling. No default value, provide one for reproducible results.}

\item{treatmentColName}{A string containing the name of a column in data.
The column contains the treatment variable specifying the treatment groups.}

\item{treatmentCode}{(optional) A string containing one of the factor levels from the treatment column.
If provided, the corresponding treatment will be considered "Treatment 1".
Otherwise, the first "level" of the column will be considered the primary treatment.}

\item{outcomeColName}{A string containing the name of a column in data.
The column contains the outcome variable to be compared between the treatment groups.
If outcomeType = "survival", the outcome column holds the failure/censor assignments.}

\item{clusterVars}{A character vector containing column names in data.
Each column contains an X-variable, or covariate which will be used to form patient clusters.}

\item{labelColName}{(optional) A string containing the name of a column from data.
The column contains labels for each of the observations in data, defaults to the row indices.}

\item{numThreads}{(optional) An integer value specifying the number of threads which will be assigned to the analysis.
The maximum number of threads varies depending on the system hardware. Defaults to 1 thread.}

\item{radiusLevels}{(optional) By default, Local Control builds a set of radii to fit data.
The radiusLevels parameter allows users to override the construction by explicitly providing a set of radii.}

\item{radStepType}{(optional) Used in the generation of correction radii.
The step type used to generate each correction radius after the maximum.
Currently accepts "unif" and "exp" (default).
"unif" for uniform decay ex: (radDecayRate = 0.1) (1, 0.9, 0.8, 0.7, ..., ~minRadFract, 0)
"exp" for exponential decay ex: (radDecayRate = 0.9) (1, 0.9, 0.81, 0.729, ..., ~minRadFract, 0)}

\item{radDecayRate}{(optional) Used in the generation of correction radii.
The size of the "step" between each of the generated correction radii.
If radStepType == "exp", radDecayRate must be a value between (0,1).
This value defaults to 0.8.}

\item{radMinFract}{(optional) Used in the generation of correction radii.
A floating point number representing the smallest fraction of the maximum radius to use as a correction radius.}

\item{normalize}{(optional) Logical value. Tells local control if it should or should not normalize the covariates. Default is TRUE.}

\item{verbose}{(optional) Logical value. Display or suppress the console output during the call to Local Control. Default is FALSE.}
}
\description{
Given a number of bootstrap iterations and the params used to call
  \code{\link{LocalControl}} with outcomeType = "default", this function calls LocalControl nBootstrap times.
  The 50\% and 95\% quantiles are drawn from the distribution of results to produce the LTD confidence intervals.
}
\examples{
\dontrun{
#input the abciximab study data of Kereiakes et al. (2000).
data(lindner)

linVars <- c("stent", "height", "female", "diabetic", "acutemi",
             "ejecfrac", "ves1proc")
results <- LocalControl(data = lindner,
                        clusterVars = linVars,
                        treatmentColName = "abcix",
                        outcomeColName = "cardbill",
                        treatmentCode = 1)

#Calculate the confidence intervals via resampling.
confResults = LocalControlNearestNeighborsConfidence(
                                        data = lindner,
                                        clusterVars = linVars,
                                        treatmentColName = "abcix",
                                        outcomeColName = "cardbill",
                                        treatmentCode = 1, nBootstrap = 20)

# Plot the local treatment difference with confidence intervals.
plot(results, confResults)
}

}
