% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolarDerivative.R
\name{PolarDerivative}
\alias{PolarDerivative}
\title{Derivative of the polar coordinate transformation}
\usage{
PolarDerivative(v)
}
\arguments{
\item{v}{A \code{d}-dimensional directional vector of length 1.}
}
\value{
The Jacobian matrix of the polar transformation theta=g(v), with
\code{d-1} rows and \code{d} columns.
}
\description{
This function compute the Jacobian matrix of the polar transformation
theta=g(v), i.e., the transformation from the the rectangular coordinate
representation of the directional vector to its angular representation.
}
\details{
See Lemma 3 of Tang and Li (2024).
}
\examples{
X=c(3,1,3)
V=X/sqrt(sum(X^2))
PolarDerivative(V)

}
\references{
\cite{Tang, Y. and Li, B. (2024), “A nonparametric test for elliptical
distribution based on kernel embedding of probabilities,”
\url{https://arxiv.org/abs/2306.10594}}
}
