% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_test_Holm.R
\name{dag_test_Holm}
\alias{dag_test_Holm}
\title{dag_test_Holm}
\usage{
dag_test_Holm(X0, p, alpha)
}
\arguments{
\item{X0}{a numeric matrix giving points corresponding to hypotheses.}

\item{p}{a numeric vector taking values in (0, 1] such that \code{length(p) == nrow(X0)}.}

\item{alpha}{a numeric value in (0, 1] specifying the Type I error rate.}
}
\value{
A boolean vector of the same length as \code{p} with each element being \code{TRUE} if the corresponding hypothesis is rejected and \code{FALSE} otherwise.
}
\description{
Given a vector of p-values, each concerning a row in the matrix X0,
\code{dag_test_Holm()} first applies Holm's method to the p-values and then also rejects
hypotheses corresponding to points coordinate-wise greater or equal to any
point whose hypothesis has been rejected.
}
\examples{
X0 <- rbind(c(0.5, 0.5), c(0.8, 0.9), c(0.4, 0.6))
p <- c(0.01, 0.1, 0.05)
alpha <- 0.05
dag_test_Holm(X0, p, alpha)

}
