% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeriTools.R
\name{computeVPC.CP}
\alias{computeVPC.CP}
\title{Calculate the compound Poisson (CP) variance partition coefficient (VPC) 
for one or more features.}
\usage{
computeVPC.CP(para)
}
\arguments{
\item{para}{A \eqn{G \times 4}{G x 4} matrix of CP fit parameters for 
\eqn{G} features, \eqn{G\geq 1}. The column order is intercept 
\eqn{\alpha_g}, random effect \eqn{\sigma_g^2 (\sigma_g^2\geq0)}, 
tweedie parameter \eqn{p_g (1<p_g<2)},
 and dispersion \eqn{\phi (\phi>0)}.}
}
\value{
A \eqn{G \times 1}{G x 1} matrix consisting of VPC for
  G features based on compound Poisson mixed models. Column name is 
  "CP-fit"; row names are the feature names.
}
\description{
Calculate the CP VPC for one or more features following the model fitting 
function fit.CP().
}
\examples{
## Compute VPC for each feature under compound Poisson mixed models. 
vpc.cp <- computeVPC.CP(para_cp) 

## Visulize the distribution of the VPCs. 
hist(vpc.cp, breaks = 50, col = "cyan")

## Plot sorted VPCs.
plot(sort(vpc.cp), ylab = "Heritability (h2)", ylim = c(0,1), main = "Sorted CP VPC scores")
abline(h = 0.9, lty = 2, col = "red")
text(50, 0.92, "h2 = 0.9", col = "red")
}
