% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgname.R
\docType{package}
\name{HTRX-package}
\alias{HTRX}
\alias{HTRX-package}
\title{HTRX: Haplotype Trend Regression with eXtra flexibility}
\description{
This is the software for "HTRX - Haplotype Trend Regression with eXtra flexibility (HTRX)"
based on the papar Genetic risk for Multiple Sclerosis originated in Pastoralist Steppe populations, Barrie et al, 2022.

HTRX searches for haplotype patterns that include single nucleotide polymorphisms (SNPs) and non-contiguous haplotypes.

HTRX is a template gives a value for each SNP taking values of ‘0’ or ‘1’, reflecting
whether the reference allele of each SNP is present or absent, or an ‘X’ meaning either value is allowed.

We used a two-step procedure to select the best HTRX model: \code{\link{do_cv}}.

Step 1: select candidate models;

Step 2: select the best model using 10-fold cross-validation.

Longer haplotypes are important for discovering interactions.
However, too many haplotypes make original HTRX unrealistic for regions with large numbers of SNPs.
We proposed "cumulative HTRX" that enables HTRX to run on longer haplotypes: \code{\link{do_cumulative_htrx}}.

The code for HTRX is hosted at \url{https://github.com/YaolingYang/HTRX}.
}
\references{
Barrie W, Yang Y, Attfield K E, et al. Genetic risk for Multiple Sclerosis originated in Pastoralist Steppe populations. bioRxiv (2022).

Efron, B. Bootstrap Methods: Another Look at the Jackknife. Ann. Stat. 7, 1-26 (1979).

Kass, R. E. & Wasserman, L. A Reference Bayesian Test for Nested Hypotheses and its Relationship to the Schwarz Criterion. J. Am. Stat. Assoc. 90, 928-934 (1995).

McFadden, D. Conditional logit analysis of qualitative choice behavior. (1973).
}
\author{
\strong{Maintainer}: Yaoling Yang \email{yaoling.yang@bristol.ac.uk} (\href{https://orcid.org/0000-0003-4905-8097}{ORCID})

Authors:
\itemize{
  \item Daniel Lawson \email{Dan.Lawson@bristol.ac.uk} (\href{https://orcid.org/0000-0002-5311-6213}{ORCID})
}

}
