% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{build.edges.from.hpo.obo}
\alias{build.edges.from.hpo.obo}
\title{Parse an HPO obo file}
\usage{
build.edges.from.hpo.obo(obofile = "hp.obo", file = "edge.file")
}
\arguments{
\item{obofile}{an HPO obo file. The extension of the obofile can be plain (".txt") or compressed (".gz").}

\item{file}{name of the file of the edges to be written. The extension of the file can be plain (".txt") or compressed (".gz").}
}
\value{
A text file representing the edges in the format: source  destination (i.e. one row for each edge).
}
\description{
Read an HPO obo file (\href{http://human-phenotype-ontology.github.io/}{HPO}) and write the edges of the dag on a plain text file.
The format of the file is a sequence of rows and each row corresponds to an edge represented through a pair of vertexes separated by blank.
}
\details{
A faster and more flexible parser to handle \emph{obo} file can be found \href{https://github.com/marconotaro/obogaf-parser}{here}.
}
\examples{
\dontrun{
hpobo <- "http://purl.obolibrary.org/obo/hp.obo";
build.edges.from.hpo.obo(obofile=hpobo, file="hp.edge");}
}
