% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{lexicographical.topological.sort}
\alias{lexicographical.topological.sort}
\title{Lexicographical Topological Sorting}
\usage{
lexicographical.topological.sort(g)
}
\arguments{
\item{g}{an object of class \code{graphNEL}}
}
\value{
a vector in which the nodes of the graph \code{g} are sorted according to a lexicographical topological order.
}
\description{
Nodes of a graph are sorted according to a lexicographical topological ordering.
}
\details{
A topological sorting is a linear ordering of the nodes such that given an edge from 
\code{u} to \code{v}, the node \code{u} comes before node \code{v} in the ordering. 
Topological sorting is not possible if the graph \code{g} is not a DAG.
To implement the topological sorting algorithm we applied the Kahn’s algorithm.
}
\examples{
data(graph);
T <- lexicographical.topological.sort(g);
}
