% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf.meas.R
\name{AUROC}
\alias{AUROC}
\alias{AUROC.single.class}
\alias{AUROC.single.over.classes}
\title{AUROC measures}
\usage{
AUROC.single.class(target, pred, folds = NULL, seed = NULL)

AUROC.single.over.classes(labels, predicted, folds = NULL, seed = NULL)
}
\arguments{
\item{target}{vector of the true labels (0 negative, 1 positive examples)}

\item{pred}{a numeric vector of the values of the predicted labels (scores)}

\item{folds}{number of folds on which computing the AUROC. If \code{folds=NULL} (\code{def.}), the one-shot AUROC is computed, 
otherwise the AUROC is computed averaged across folds.}

\item{seed}{initialization seed for the random generator to create folds. Set \code{seed} only if \code{folds}\eqn{\neq}\code{NULL}.
If \code{seed}\eqn{\neq}\code{NULL} and \code{folds=NULL}, the AUROC averaged across folds is computed without seed initialization.}

\item{labels}{matrix with the target multilabels: rows correspond to examples and columns to classes. 
\eqn{target[i,j]=1} if example \eqn{i} belongs to class \eqn{j}, \eqn{target[i,j]=0} otherwise.}

\item{predicted}{a numeric matrix with predicted values (scores): rows correspond to examples and columns to classes.}
}
\value{
\code{AUROC.single.class} returns a numeric value corresponding to the AUROC for the considered class;\cr
\code{AUPR.single.over.classes} returns a list with two elements:
\enumerate{
	\item average: the average AUROC across classes;        
	\item per.class: a named vector with AUROC for each class. Names correspond to classes.
}
}
\description{
Function to compute the Area under the ROC Curve through \pkg{precrec} package
}
\details{
The AUROC (for a single class or for a set of classes) is computed either one-shot or averaged across stratified folds.

\code{AUROC.single.class} computes the AUROC just for a given class.

\code{AUROC.single.over.classes} computes the AUROC for a set of classes, including their average values across all the classes.

For all those classes having zero annotations, the AUROC is set to 0.5. These classes are included in the computing of the AUROC 
averaged across classes, both when the AUROC is computed one-shot or averaged across stratified folds.

The AUROC is set to 0.5 to all those classes having zero annotations.
Names of rows and columns of \code{labels} and \code{predicted} must be provided in the same order, otherwise a stop message is returned
}
\examples{
data(labels);
data(scores);
data(graph);
root <- root.node(g);
L <- L[,-which(colnames(L)==root)];
S <- S[,-which(colnames(S)==root)];
AUC.single.class <- AUROC.single.class(L[,3], S[,3], folds=5, seed=23);
AUC.over.classes <- AUROC.single.over.classes(L, S, folds=5, seed=23);
}
