% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.fun.R
\name{Do.flat.scores.normalization}
\alias{Do.flat.scores.normalization}
\title{Flat scores normalization}
\usage{
Do.flat.scores.normalization(norm.type = "MaxNorm", flat.file = flat.file,
  flat.dir = flat.dir, flat.norm.dir = flat.norm.dir)
}
\arguments{
\item{norm.type}{can be one of the following two values:
\itemize{
\item MaxNorm (\code{def.}): each score is divided w.r.t. the max of each class;
\item Qnorm: a quantile normalization is applied. Library preprocessCore is used.
}}

\item{flat.file}{name of the flat scores matrix (without rda extension)}

\item{flat.dir}{relative path to folder where flat scores matrix is stored}

\item{flat.norm.dir}{the directory where the normalized flat scores matrix must be stored}
}
\value{
the matrix of the scores flat normalized w.r.t. MaxNorm or Qnorm in \code{flat.norm.dir}
}
\description{
High level functions to normalize a flat scores matrix w.r.t. max normalization (MaxNorm) or quantile normalization (Qnorm)
}
\details{
To apply the quantile normalization the \pkg{preprocessCore} library is uded.
}
\examples{
data(scores);
if(!dir.exists("data")){
	dir.create("data");
}
if(!dir.exists("results")){
	dir.create("results");
}
save(S,file="data/scores.rda");
flat.dir <- "data/";
flat.norm.dir <- "results/";
flat.file <- "scores";
norm.types <- c("MaxNorm","Qnorm");
for(norm.type in norm.types){
	Do.flat.scores.normalization(norm.type=norm.type, flat.file=flat.file, 
flat.dir=flat.dir, flat.norm.dir=flat.norm.dir);
}
}
