% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf.meas.R
\name{PXR}
\alias{PXR}
\alias{PXR.at.multiple.recall.levels.over.classes}
\title{Precision at fixed Recall level}
\usage{
PXR.at.multiple.recall.levels.over.classes(target, pred, rec.levels = seq(from
  = 0.1, to = 1, by = 0.1), folds = NULL, seed = NULL)
}
\arguments{
\item{target}{matrix with the target multilabels: rows correspond to examples and columns to classes. 
\eqn{target[i,j]=1} if example \eqn{i} belongs to class \eqn{j}, \eqn{target[i,j]=0} otherwise.}

\item{pred}{a numeric matrix with predicted values (scores): rows correspond to examples and columns to classes.}

\item{rec.levels}{a vector with the desired recall levels (\code{def:} \code{from:0.1}, \code{to:0.9}, \code{by:0.1})}

\item{folds}{number of folds on which computing the AUROC. If \code{folds=NULL} (\code{def.}), the one-shot AUROC is computed, 
otherwise the AUROC is computed averaged across folds.}

\item{seed}{initialization seed for the random generator to create folds. Set \code{seed} only if \code{folds}\eqn{\neq}\code{NULL}.
If \code{seed}\eqn{\neq}\code{NULL} and \code{folds=NULL}, the AUROC averaged across folds is computed without seed initialization.}
}
\value{
a list with two elements:
\enumerate{
\item average: a vector with the the average precisions at different recall levels across classes
\item per.class: a matrix with the precisions at different recall levels: rows are classes, columns precisions at different recall level
}
}
\description{
Function to compute the Precision at fixed Recall levels (PXR) over classes through \pkg{PerfMeas} package
}
\details{
The PXR across all classes is computed either one-shot or averaged across stratified folds

Function to compute the precision at fixed recall levels across all classes either one-shot or averaged across stratified folds
}
\examples{
data(labels);
data(scores);
data(graph);
root <- root.node(g);
L <- L[,-which(colnames(L)==root)];
S <- S[,-which(colnames(S)==root)];
rec.levels <- seq(from=0.1, to=1, by=0.1);
PXR <- PXR.at.multiple.recall.levels.over.classes(L, S, rec.levels=rec.levels, folds=5, seed=23);
}
