% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HEMDAG.1.0.0.R
\name{do.edges.from.HPO.obo}
\alias{do.edges.from.HPO.obo}
\title{Parse an HPO OBO file}
\usage{
do.edges.from.HPO.obo(file = "hp.obo", output.file = "edge.file")
}
\arguments{
\item{file}{an HPO OBO file}

\item{output.file}{name of the file of the edges to be written}
}
\value{
a text file representing the edges in the format: source  destination (i.e. one row for each edge)
}
\description{
Read an HPO OBO file (\href{http://human-phenotype-ontology.github.io/}{HPO}) and write 
the edges of the DAG on a plain text file.The format of the file is a sequence of
rows and each row corresponds to an edge represented through a pair of vertices separated by blanks
}
\examples{
\dontrun{
hpobo <- "http://purl.obolibrary.org/obo/hp.obo";
do.edges.from.HPO.obo(file=hpobo, output.file="hp.edge");}
}
