% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{thunnus}
\alias{thunnus}
\title{Yellowfin Tuna (\emph{Thunnus albacares}) Worldwide Occurrence Records}
\format{
A data frame with 80,163 rows and 3 variables:
\describe{
  \item{decimalLongitude}{Numeric. Longitude coordinates (WGS84).}
  \item{decimalLatitude}{Numeric. Latitude coordinates (WGS84).}
  \item{year}{Integer. Year in which the observation was recorded.}
}
}
\source{
Global Biodiversity Information Facility (GBIF) \cr
GBIF Occurrence Download https://doi.org/10.15468/dl.xsyrkh \cr
Accessed from R via \pkg{rgbif} (https://github.com/ropensci/rgbif) on 2025-02-07
}
\usage{
data("thunnus")
}
\description{
This dataset contains georeferenced occurrence records of the Yellowfin Tuna
(\emph{Thunnus albacares}) from 1950 to 2025, obtained globally from the Global Biodiversity
Information Facility (GBIF). The dataset was filtered to include presence-only records
with valid geographic coordinates and year, and duplicate coordinates were removed.
}
\details{
The data were accessed through the GBIF API and used for benchmarking thinning algorithms
in the GeoThinneR package. Coordinates include marine records, and
the data were globally sampled across many decades.

For reproducibility, the GBIF download script is included in \code{data-raw/thunnus_download.R}.
}
\keyword{datasets}
