% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_probability_functions.R
\name{summary.gGenericSize}
\alias{summary.gGenericSize}
\title{Summarize the gGenericSize list to a list of simple tables}
\usage{
\method{summary}{gGenericSize}(object, ..., CL = 0.9)
}
\arguments{
\item{object}{gGenericSize output list (each element is a size-named 
list of named vectors of gGeneric values for a cell in the model 
combinations)}

\item{...}{arguments to be passed down}

\item{CL}{confidence level}
}
\value{
a list of summary tables of g values (medians and confidence 
  bounds) for each cell combination within the gGeneric list
}
\description{
methods for \code{summary} applied to a \code{gGenericSize}
  list
}
\examples{
  data(mock)
  pkmModsSize <- pkm(formula_p = p ~ HabitatType,
                   formula_k = k ~ HabitatType, data = mock$SE,
                   obsCol = c("Search1", "Search2", "Search3", "Search4"),
                   sizeCol = "Size", allCombos = TRUE)
  cpmModsSize <- cpm(formula_l = l ~ Visibility,
                   formula_s = s ~ Visibility, data = mock$CP,
                   left = "LastPresentDecimalDays",
                   right = "FirstAbsentDecimalDays",
                   dist = c("exponential", "lognormal"),
                   sizeCol = "Size", allCombos = TRUE)
  pkMods <- c("S" = "p ~ 1; k ~ 1", "L" = "p ~ 1; k ~ 1",
             "M" = "p ~ 1; k ~ 1", "XL" = "p ~ 1; k ~ 1"
            )
  cpMods <- c("S" = "dist: exponential; l ~ 1; NULL", 
              "L" = "dist: exponential; l ~ 1; NULL",
              "M" = "dist: exponential; l ~ 1; NULL",
              "XL" = "dist: exponential; l ~ 1; NULL"
            )
  avgSS <- averageSS(mock$SS)
  gsGeneric <- estgGenericSize(nsim = 1000, days = avgSS,
                 modelSetSize_SE = pkmModsSize,
                 modelSetSize_CP = cpmModsSize,
                 modelSizeSelections_SE = pkMods,
                 modelSizeSelections_CP = cpMods
               )
 summary(gsGeneric)

}
