% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carcass_persistence_functions.R
\name{aicc.cpm}
\alias{aicc.cpm}
\title{Extract AIC and AICc for a carcass persistence model}
\usage{
\method{aicc}{cpm}(x, ...)
}
\arguments{
\item{x}{Carcass persistence model (\code{cpm} objects)}

\item{...}{further arguments passed to or from other methods}
}
\value{
AIC, AICc vector
}
\description{
S3 function for generating AIC for \code{\link{cpm}} objects
}
\examples{
  data(wind_RP)
  mod <- cpm(formula_l = l ~ Season, formula_s = s ~ Season,
           data = wind_RP$CP, left = "LastPresent", right = "FirstAbsent")
 aicc(mod)

}
