% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inventory.R
\name{get_inventory}
\alias{get_inventory}
\title{Download and Return a data.table Object of GSOD Weather Station Data Inventories}
\usage{
get_inventory()
}
\value{
A \code{GSODR.info} object, which inherits from \link[data.table:data.table]{data.table::data.table}.
}
\description{
The \acronym{NCEI} maintains a document,
\url{https://www1.ncdc.noaa.gov/pub/data/noaa/isd-inventory.txt}, which lists
the number of weather observations by station-year-month from the beginning
of the stations' records.  This function retrieves that document and prints
an information header displaying the last update time with a data frame of
the inventory information for each station-year-month.
}
\note{
While \CRANpkg{GSODR} does not distribute GSOD weather data, users of
the data should note the conditions that the U.S. \acronym{NCEI} places upon
the \acronym{GSOD} data.
\dQuote{The following data and products may have conditions placed on their
international commercial use.  They can be used within the U.S. or for non-
commercial international activities without restriction.  The non-U.S. data
cannot be redistributed for commercial purposes.  Re-distribution of these
data by others must provide this same notification.  A log of IP addresses
accessing these data and products will be maintained and may be made
available to data providers.}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
inventory <- get_inventory()
inventory
\dontshow{\}) # examplesIf}
}
\seealso{
Other metadata: 
\code{\link{get_isd_history}()},
\code{\link{get_updates}()}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
\concept{metadata}
