% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_covariates.R
\name{get_covariates}
\alias{get_covariates}
\title{Retrieve Covariates from a \code{GHRmodels} Object as a List of Character Vectors}
\usage{
get_covariates(model, unique = TRUE)
}
\arguments{
\item{model}{A \code{GHRmodels} object containing fitted models.}

\item{unique}{Logical; if \code{TRUE}, returns unique covariates across models.
If \code{FALSE}, returns vectors of covariate combinations as declared in the \code{GHRmodels} object.}
}
\value{
A list of character vectors.
}
\description{
Extracts covariates from a \code{GHRmodels} object and returns them as a list of character vectors.
If \code{unique = TRUE}, the output contains unique covariates across models. If \code{unique = FALSE},
the output preserves the original combinations of covariates as specified in the \code{GHRmodels} object.
}
\examples{
\donttest{
# Load example dataset
data(dengueMS)

# Declare formulas
formulas <- c(
  "dengue_cases ~ tmin +  f(year, model='rw1')",
  "dengue_cases ~ pdsi +  f(year, model='rw1')"
)

# Tranform formulas into a 'GHRformulas' object
ghr_formulas <- as_GHRformulas(formulas)

# Fit multiple models 
results <- fit_models(
  formulas = ghr_formulas,
  data     = dengue_MS,
  family   = "nbinomial",
  name     = "TestModel",
  offset   = "population",
  nthreads = 2,
  control_compute = list(config = FALSE),
  pb       = TRUE
)

# Extract the list of covariates from the models 
get_covariates(results)
}
}
