% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruction.R
\name{reconstruction}
\alias{reconstruction}
\title{Full data reconstruction based on posterior samples}
\usage{
reconstruction(res, average = TRUE)
}
\arguments{
\item{res}{The sampled model from function \code{\link{gfa}}}

\item{average}{If TRUE (default), averages the reconstruction over the
posterior predictive samples. If set to
FALSE, the output may require a large amount of memory. In case of large
input data, we recommend acquiring the posterior predictive samples for
subsets of data at a time, based on this implementation.}
}
\value{
The data reconstruction, a numeric  \eqn{N \times \sum_{m=1}^M D_m} 
  matrix, if average is TRUE (default). Otherwise, the reconstruction is a
  \eqn{N \times \sum_{m=1}^M D_m \times Npost} array, with posterior samples
  in the third dimension. If the input data has been paired in two modes, the
  output will be a list of length 2, one element corresponding to each mode.
}
\description{
\code{reconstruction} returns the full data reconstruction based on given
posterior samples.
}
