% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcc_show_bicluster_coverage.R
\name{funcc_show_bicluster_coverage}
\alias{funcc_show_bicluster_coverage}
\title{plotting coverage of each bi-cluster}
\usage{
funcc_show_bicluster_coverage(
  fun_mat,
  res_input,
  not_assigned = TRUE,
  max_coverage = 1
)
}
\arguments{
\item{fun_mat}{The data array (n x m x T) where each entry corresponds to the measure of one observation i, i=1,...,n, for a functional variable m, m=1,...,p, at point t, t=1,...,T}

\item{res_input}{An object produced by the funcc_biclust function}

\item{not_assigned}{logicol: if true also the cluster of not assigned elements is included}

\item{max_coverage}{scalar: percentage of maximum cumulative coverage to be shown}
}
\value{
a figure representing for each bi-cluster the coverage in terms of percentage of included functions
}
\description{
funcc_show_bicluster_coverage graphically shows the coverage of each bi-cluster in terms of percentage of included functions
}
\examples{
 
data("funCCdata")
res <- funcc_biclust(funCCdata,delta=10,theta=1,alpha=1,beta=0,const_alpha=TRUE)
funcc_show_bicluster_coverage(funCCdata,res)
}
