% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_ccircle_spatial_notrees.R
\name{new_fe_ccircle_spatial_notrees}
\alias{new_fe_ccircle_spatial_notrees}
\title{Constructor for the \strong{fe_ccircle_spatial_notrees} Class}
\usage{
new_fe_ccircle_spatial_notrees(x = list(), ..., class = character())
}
\arguments{
\item{x}{An appropriate \code{list} object}

\item{...}{Additional arguments required for enabling subclasses of
\code{fe_ccircle_spatial_notrees}}

\item{class}{A Character string required for enabling subclasses of
\code{fe_ccircle_spatial_notrees}}
}
\value{
An object of class \code{fe_ccircle_spatial_notrees}
}
\description{
Should be used by expert users only who know exactly what they are doing.
Other users please take the function \code{\link{fe_stand}} for creating an
object of that class.
}
\details{
The class \code{fe_ccircle_spatial_notrees} has been designed for covering
a comparably rare case, i.e. an inventory point where no regular trees
(trees that are big enough to have a dbh), but possibly small trees are
present.
}
\examples{
#' # Constructing a minimal fe_ccircle_spatial object from scratch
# Use fe_ccircle_spatial() if you are not absolutely sure

trees <- NULL
tree_positions <- NULL

# define a circle definition with three concentric circles
circle_def <- data.frame(
  dbh_lower = c(0,12,30),
  dbh_upper = c(11.9,29.9,999.0),
  c_area = c(0.0025, 0.0060, 0.0500)
)


# generate a NA dummy for small_trees

  small_trees <- data.frame(
  tree_id = NA_character_,
  species_id = NA_character_,
  layer_key = NA_real_,
  time_yr = NA_real_,
  dbh_cm = NA_real_,
  age_yr = NA_real_,
  height_m = NA_real_
  )

fe_ccircle_spatial_notrees_candidate <- list(
  stand_id = "my_interesting_stand",
  small_trees = small_trees,
  trees = trees,
  circle_definition = circle_def,
  tree_positions = tree_positions,
  time_yr = 2024
)

fe_ccircle_notrees_object <-
new_fe_ccircle_spatial_notrees(fe_ccircle_spatial_notrees_candidate)

# Better validate it
fe_ccircle_notrees_object |> validate_fe_ccircle_spatial_notrees()


}
