% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_design_initial_GLM.R
\name{EW_design_initial_GLM}
\alias{EW_design_initial_GLM}
\title{function to generate a initial EW Design for generalized linear models}
\usage{
EW_design_initial_GLM(
  k.continuous,
  factor.level,
  Integral_based,
  b_matrix,
  joint_Func_b,
  Lowerbounds,
  Upperbounds,
  xlist_fix = NULL,
  lvec,
  uvec,
  h.func,
  link = "continuation",
  delta = 1e-06,
  epsilon = 1e-12,
  maxit = 1000
)
}
\arguments{
\item{k.continuous}{number of continuous variables}

\item{factor.level}{lower, upper limit of continuous variables, and discrete levels of categorical variables, continuous factors come first}

\item{Integral_based}{TRUE or FALSE, if TRUE then we will find the integral-based EW D-optimality otherwise we will find the sample-based EW D-optimality}

\item{b_matrix}{The matrix of the sampled parameter values of beta}

\item{joint_Func_b}{The prior joint probability distribution of the parameters}

\item{Lowerbounds}{The lower limit of the prior distribution for each parameter}

\item{Upperbounds}{The upper limit of the prior distribution for each parameter}

\item{xlist_fix}{the restricted discrete settings to be chosen, default to NULL, if NULL, will generate a discrete uniform random variables}

\item{lvec}{lower limit of continuous variables}

\item{uvec}{upper limit of continuous variables}

\item{h.func}{function, is used to transfer the design point to model matrix (e.g. add interaction term, add intercept)}

\item{link}{link function, default "continuation", other options "baseline", "adjacent" and "cumulative"}

\item{delta}{tuning parameter, the distance threshold, || x_i(0) - x_j(0) || >= delta}

\item{epsilon}{determining f.det > 0 numerically, f.det <= epsilon will be considered as f.det <= 0}

\item{maxit}{maximum number of iterations}
}
\value{
X        matrix of initial design point

p0       initial random approximate allocation

f.det    the determinant of the expected Fisher information matrix for the initial design
}
\description{
function to generate a initial EW Design for generalized linear models
}
