% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.cpts.R
\name{screen.cpts}
\alias{screen.cpts}
\title{Change point time series plot}
\usage{
screen.cpts(metrics, type = "a", title = FALSE, change.margins = TRUE)
}
\arguments{
\item{metrics}{output from \code{\link{metrics.all}}}

\item{type}{character indicating which type of metric to compile change points for.
Options are "h" for high flow metrics, "l" for low flow metrics, "b" for baseflow 
metrics, or "a" for all 30 metrics (10 high, 10 low, 10 baseflow).}

\item{title}{optional plot title. Default is FALSE indicating no plot title is wanted. 
Set to TRUE to use the the default plot title, which will 
look for 'plot title' attribute of the data.frame set by 
\code{\link{set.plot.titles}}. All values other values 
will be used as a custom plot title.}

\item{change.margins}{TRUE or FALSE to indicate whether the user's current 
margin settings should be used, or if the margins should be set within the 
function. Default is TRUE, to set margins to the minimal amount.}
}
\value{
When type="a", returns a data.frame of changepoint counts by metric 
  type and year.
}
\description{
Compiles change point information for all metrics and outputs a daily flow
time series plot overlain with a bar plot of changepoint counts by year.
}
\examples{
# load results from metrics.all function for the Caniapiscau River
data(caniapiscau.res)

# plot changepoints for all groups of metrics
screen.cpts(caniapiscau.res, type="l")
screen.cpts(caniapiscau.res, type="h")
screen.cpts(caniapiscau.res, type="b")
}
\seealso{
\code{\link{metrics.all}}
}
\author{
Jennifer Dierauer
}
