% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.jmcs.R
\name{residuals}
\alias{residuals}
\alias{residuals.jmcs}
\title{Residuals for joint models}
\usage{
\method{residuals}{jmcs}(object, type = c("Marginal", "Subject"), ...)
}
\arguments{
\item{object}{an object inheriting from class \code{jmcs}.}

\item{type}{what type of residuals to calculate.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a vector of residuals of the longitudinal sub-model.
}
\description{
Extract residuals for joint models.
}
\examples{
\donttest{
# a joint model fit
fit <- jmcs(ydata = ydata, cdata = cdata, 
            long.formula = response ~ time + gender + x1 + race, 
            surv.formula = Surv(surv, failure_type) ~ x1 + gender + x2 + race, 
            random =  ~ time| ID)

# residuals of the longitudinal sub-model
head(cbind(
  "Marg" = residuals(fit, type = "Marginal"), 
  "Subj" = residuals(fit, type = "Subject")
))
}
}
\seealso{
\code{\link{jmcs}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
