% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectThresholdRange}
\alias{selectThresholdRange}
\title{Select threshold range}
\usage{
selectThresholdRange(p.threshold = 0.8)
}
\arguments{
\item{p.threshold}{\itemize{
\item Number between 0 and 1
}}
}
\value{
Returns a direct search function that is used in the feature selection process.
}
\description{
Generates a direct search function that selects the features whose evaluation is over a threshold, where this threshold is given as: (((min - max) * p.threshold) + max)(The features evaluation is individual). This function is called internally within the \code{\link{directSearchAlgorithm}} function.
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a direct search process
## Classification problem


# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the direct search function with threshold range
str_direct_search <- selectThresholdRange()
# Performs the direct search process directly (parameters: dataset, target variable and evaluator)
str_direct_search(iris, 'Species', filter_evaluator)
}
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
