% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_stats.R
\name{comp_pred}
\alias{comp_pred}
\title{Fit and predict competing classification algorithms}
\usage{
comp_pred(
  formula,
  data.train,
  data.test = NULL,
  algorithm = NULL,
  model = NULL,
  sens.w = NULL,
  new.factors = "exclude",
  quiet_mis = FALSE
)
}
\arguments{
\item{formula}{A formula (usually \code{x$formula}, for an \code{FFTrees} object \code{x}).}

\item{data.train}{A training dataset (as a data frame).}

\item{data.test}{A testing dataset (as a data frame).}

\item{algorithm}{A character string specifying an algorithm in the set:
\itemize{
  \item{\code{"lr"}: Logistic regression (using \code{\link{glm}} from \strong{stats} with \code{family = "binomial"});}
  \item{\code{"rlr"}: Regularized logistic regression (currently not supported);}
  \item{\code{"cart"}: Decision trees (using \code{rpart} from \strong{rpart});}
  \item{\code{"svm"}: Support vector machines (using \code{svm} from \strong{e1071});}
  \item{\code{"rf"}: Random forests (using \code{randomForest} from \strong{randomForest}.}
}}

\item{model}{An optional existing model (as a \code{model}), to be applied to the test data.}

\item{sens.w}{Sensitivity weight parameter (numeric, from \code{0} to \code{1}), required to compute \code{wacc}.}

\item{new.factors}{What should be done if new factor values are discovered in the test set (as a character string)?
Available options:
\itemize{
  \item{\code{"exclude"}: exclude case (i.e., remove these cases, used by default);}
  \item{\code{"base"}: predict the base rate of the criterion.}
}}

\item{quiet_mis}{A logical value passed to hide/show \code{NA} user feedback
(usually \code{x$params$quiet$mis} of the calling function).
Default: \code{quiet_mis = FALSE} (i.e., show user feedback).}
}
\description{
\code{comp_pred} provides a wrapper for running (i.e., fit or predict)
alternative classification algorithms to data
(i.e., \code{data.train} or \code{data.test}, respectively).
}
\details{
The range of competing algorithms currently available includes
logistic regression (\code{stats::glm}),
CART (\code{rpart::rpart}),
support vector machines (\code{e1071::svm}), and
random forests (\code{randomForest::randomForest}).

The current support for handling missing data (or \code{NA} values) is only rudimentary.
When enabled (via the global options \code{allow_NA_pred} or \code{allow_NA_crit}),
any rows in \code{data.train} or \code{data.test} with incomplete cases are being removed
prior to fitting or predicting a model (by using \code{na.omit} from \strong{stats}).
See the specifications of each model for more sophisticated ways of handling missing data.
}
