% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.data.R
\name{check.data}
\alias{check.data}
\title{Check correctness and consistency of input data}
\usage{
check.data(X, q, l, c, ...)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{q}{\code{Numeric} scalar, number of end-members to be modelled.}

\item{l}{\code{Numeric} scalar or vector, weight transformation
limit, i.e.  quantile.}

\item{c}{\code{Numeric} scalar, constant sum scaling parameter, e.g.
1, 100, 1000.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
\code{Character} vector, verbose test results.
}
\description{
The input data matrix (\code{X}), number of end-members (\code{q}), 
weight transformation limits (l) and constant sum scaling parameter 
(\code{c}) are checked. This includes checking for absence of missing 
values, columns containing only zero-values and for numeric data type of 
all variables. A further check tests if \code{l} is below the maximum 
possible value, preventing numerical instability prior to factor rotation.
}
\examples{

## load example data set
data(example_X)

## perform data set check
check.data(X = X, 
           q = 6, 
           l = seq(from = 0, 
                   to = 0.2, 
                   by = 0.01), 
           c = 1)

}
\seealso{
\code{EMMA}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
