% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get.q.R
\name{get.q}
\alias{get.q}
\title{Generate a parameter matrix with q.min and q.max values for robust EMMA.}
\usage{
get.q(X, l = 0, q.min = 2, q.max = 10, criteria.min = 0.5,
  criteria.max = "local_max", correct.output = TRUE, ...)
}
\arguments{
\item{X}{Numeric matrix with m samples (rows) and n variables (columns).}

\item{l}{Numeric vector, weight transformation limits, default is zero.}

\item{q.min}{Numeric scalar, minimum number of end-members to use, default
is 2.}

\item{q.max}{Numeric scalar, maximum number of end-members to use, default
is 10.}

\item{criteria.min}{Numeric scalar, minimum value of explained variance
reached to be a valid model realisation, default is 0.5.}

\item{criteria.max}{Character or numeric scalar, either keyword
\code{"local_max"} to use first local maximum or any numeric value of
explained variance, default is \code{"local_max"}.}

\item{correct.output}{Logical scalar, option to correct the output for
twisted values and remove combinations with NA-values.}

\item{...}{Further arguments, passed to the function.}
}
\value{
Numeric matrix with minimum and maximum numbers of end-members as
well as corresponding weight transformation values as rownames.
}
\description{
This function uses the input data matrix \code{X} and a vector of weight
transformation limits to generate a matrix of minimum and maximum likely
numbers of end-members to be used to model and extract robust end-members.
}
\examples{
## load example data set
data(X, envir = environment())

## create parameter matrix
get.q(X = X, l = c(0, 0.05, 0.10, 0.15))
}
\author{
Michael Dietze, Elisabeth Dietze
}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{\link{EMMA}}, \code{\link{test.parameters}},
\code{\link{test.robustness}}
}
\keyword{EMMA}

