% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differences.R
\name{DurgaDiff.formula}
\alias{DurgaDiff.formula}
\title{Formula interface for estimating group mean differences}
\usage{
\method{DurgaDiff}{formula}(x, data = NULL, id.col, ...)
}
\arguments{
\item{x}{a formula, such as \code{y ~ grp}, where \code{y} is a numeric
vector of data values or measurements to be split into groups according to
the grouping variable \code{grp}, which is typically a categorical value.
Multiple group columns can be separated by \code{+}, in which case Durga treats
each unique combination of group variables as a distinct group.}

\item{data}{a data.frame (or list) from which the variables in formula should
be taken.}

\item{id.col}{Specify for paired data/repeated measures/with-subject
comparisons only. Name or index of ID column for repeated measures/paired
data. Observations for the same individual must have the same ID. For
non-paired data, do not specify an \code{id.col}, (or use \code{id.col =
  NA}).}

\item{...}{
  Arguments passed on to \code{\link[=DurgaDiff.default]{DurgaDiff.default}}
  \describe{
    \item{\code{groups}}{Vector of group names. Defaults to all groups in \code{x} in
\emph{natural} order. If \code{groups} is a named vector, the names are
used as group labels for plotting or printing. If \code{data.col} and
\code{group.col} are not specified, \code{x} is assumed be to in \emph{wide
format}, and \code{groups} must be a list of column names identifying the
group/treatment data (see example).}
    \item{\code{contrasts}}{Specify the pairs of groups to be compared. By default, all
pairwise differences are generated. May be a single string, a vector of
strings, or a matrix. Specify
\code{NULL} to avoid calculating any contrasts. See Details for more information.}
    \item{\code{effect.type}}{Type of group difference to be estimated. Values cannot be
abbreviated. See Details for further information.}
    \item{\code{R}}{The number of bootstrap replicates. \code{R} should be larger than
your sample size, so the default value of 1000 may need to be increased for
large sample sizes. If \code{R <= nrow(x)}, an error such as "\code{Error in
  bca.ci... estimated adjustment 'a' is NA}" will be thrown. Additionally,
warnings such as "\code{In norm.inter(t, adj.alpha) : extreme order
  statistics used as endpoints}" may be avoided by increasing \code{R}.
Specify \code{R = NA} if you do not wish to calculate any CIs, either
for group means for for effect sizes. This may be useful if Durga is
only being used for plotting large data sets.}
    \item{\code{boot.params}}{Optional list of additional names parameters to pass to
the \code{\link[boot]{boot}} function.}
    \item{\code{ci.conf}}{Numeric confidence level of the required confidence interval,
e.g. \code{ci.conf = 0.95} specifies that 95\\% confidence intervals should
be calculated. Applies to both CI of effect sizes and CI of group means.}
    \item{\code{boot.ci.params}}{Optional list of additional names parameters to pass to
the \code{\link[boot]{boot.ci}} function.}
    \item{\code{na.rm}}{a logical evaluating to TRUE or FALSE indicating whether NA
values should be stripped before the computation proceeds. If \code{TRUE}
for "paired" data (i.e. \code{id.col} is specified), all rows
(observations) for IDs with missing data are stripped.}
  }}
}
\value{
A \code{DurgaDiff} object, which is a list containing:

\item{\code{group.statistics}}{Matrix with a row for each group, columns
are: \code{mean}, \code{median}, \code{sd} (standard deviation), \code{se}
(standard error of the mean), \code{CI.lower} and \code{CI.upper} (lower
and upper bootstrapped confidence intervals of the mean, confidence level
as set by the \code{ci.conf} parameter) and \code{n} (group sample size).
If there are fewer than 3 distinct values in the group, or if \code{R} is
\code{NA}, the confidence interval will not be calculated and
\code{CI.lower} and \code{CI.upper} will be \code{NA}.}

\item{\code{group.differences}}{List of \code{DurgaGroupDiff} objects,
which are \code{boot} objects with added confidence interval information.
See \code{\link[boot]{boot}} and \code{\link[boot]{boot.ci}}. This element will be missing
if \code{contrasts} is empty or \code{NULL}}

\item{\code{groups}}{Vector of group names}
\item{\code{group.names}}{Labels used to identify groups}
\item{\code{effect.type}}{Value of \code{effect.type} parameter}
\item{\code{effect.name}}{Name of the effect type; may include formatting
such as subscripts} \item{\code{effect.name.print}}{Text-only version of
\code{effect.name} for printing; subscripts are indicated by \code{"_"}}
\item{\code{data.col}}{Value of \code{data.col} parameter; may be an index
or a name} \item{\code{data.col.name}}{Name of the \code{data.col} column}
\item{\code{group.col}}{Value of \code{group.col} parameter; may be an
index or a name}
\item{\code{group.col.name}}{Name of the \code{group.col} column}
\item{\code{id.col}}{Value of \code{id.col} parameter. May be \code{NULL}}
\item{\code{paired.data}}{\code{TRUE} if paired differences
were estimated}
\item{\code{data}}{The input data frame (\code{x}), or the reshaped (long format) data
frame if the input data set was in wide format}
\item{\code{call}}{How this function was called}

A \code{DurgaGroupDiff} object is a \code{boot} object (as returned by
\code{\link[boot]{boot}}) with added \code{bootci} components (as returned
by \code{\link[boot]{boot.ci}}) and components identifying the groups used
to estimate the difference. Particularly relevant members are:

\item{\code{t0}}{The observed value of the statistic}
\item{\code{bca[4]}}{The lower endpoint of the confidence interval}
\item{\code{bca[5]}}{The upper endpoint of the confidence interval}
\item{\code{groups}}{The difference is estimated on \code{groups[1]} -
\code{groups[2]}}
}
\description{
Estimates differences between groups in preparation for plotting by
\code{\link{DurgaPlot}}. The formula interface allows the value and group
columns to be specified in a formula, which means, for example, that
transformation functions can be applied to columns.
}
\details{
Applies the formula, \code{x}, and a data set, \code{data}, to construct a
data frame that is then passed, with all remaining arguments, to the function
\code{\link{DurgaDiff.default}}.
}
\examples{

d <- DurgaDiff(log(sugar) ~ treatment, insulin, id.col = "id")
print(d)

}
\references{
\itemize{
\item Cumming, G. (2012). Understanding the new statistics : effect sizes,
confidence intervals, and meta-analysis (1st ed.). New York: Routledge.
\item Delacre, M., Lakens, D., Ley, C., Liu, L., & Leys, C. (2021). Why
Hedges' g* based on the non-pooled standard deviation should be reported
with Welch's t-test. \doi{10.31234/osf.io/tu6mp}
\item Khan, M. K., & McLean, D. J. (2023). Durga: An R package for effect size estimation
and visualisation. bioRxiv, 2023.2002.2006.526960.
\doi{10.1101/2023.02.06.526960}
\item Lakens, D. (2013). Calculating and reporting effect sizes to facilitate
cumulative science: a practical primer for t-tests and ANOVAs. Frontiers in
Psychology, 4. \doi{10.3389/fpsyg.2013.00863}
}
}
\seealso{
\code{\link{DurgaDiff.default}}, \code{\link[boot]{boot}},
\code{\link[boot]{boot.ci}}, \code{\link{DurgaPlot}}
}
