/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Color;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.plots.Aes;
import org.rosuda.deducer.plots.ParamFactory;
import org.rosuda.deducer.toolkit.XMLHelper;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamCharacter;
import org.rosuda.deducer.widgets.param.ParamLogical;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Geom {
    public String name;
    public Vector aess = new Vector();
    public Vector params = new Vector();
    public String defaultStat;
    public String defaultPosition;

    public Object clone() {
        Object object;
        int n;
        Geom geom = new Geom();
        geom.name = this.name;
        geom.defaultStat = this.defaultStat;
        geom.defaultPosition = this.defaultPosition;
        for (n = 0; n < this.aess.size(); ++n) {
            object = (Aes)this.aess.get(n);
            geom.aess.add(((Aes)object).clone());
        }
        for (n = 0; n < this.params.size(); ++n) {
            object = (Param)this.params.get(n);
            geom.params.add(((Param)object).clone());
        }
        return geom;
    }

    public static Geom makeAbline() {
        Geom geom = new Geom();
        geom.name = "abline";
        geom.defaultPosition = "identity";
        geom.defaultStat = "abline";
        Aes aes = Aes.makeAes("intercept");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("slope");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.required = false;
        aes.defaultValue = new Double(0.5);
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.required = false;
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeArea() {
        Geom geom = new Geom();
        geom.name = "area";
        geom.defaultPosition = "identity";
        geom.defaultStat = "identity";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.required = false;
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.defaultValue = new Color(51, 51, 51);
        aes.value = new Color(51, 51, 51);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.required = false;
        aes.defaultValue = new Double(0.5);
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.required = false;
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("na.rm");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeBar() {
        Geom geom = new Geom();
        geom.name = "bar";
        geom.defaultStat = "bin";
        geom.defaultPosition = "stack";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.required = false;
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.value = new Color(51, 51, 51);
        aes.defaultValue = new Color(51, 51, 51);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.required = false;
        aes.defaultValue = new Double(0.5);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("weight");
        aes.required = false;
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeBin2d() {
        Geom geom = new Geom();
        geom.name = "bin2d";
        geom.defaultStat = "bin2d";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("xmin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("xmax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.required = false;
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.value = new Color(153, 153, 153);
        aes.defaultValue = new Color(153, 153, 153);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.required = false;
        aes.defaultValue = new Double(0.5);
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("weight");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeBlank() {
        Geom geom = new Geom();
        geom.name = "blank";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        return geom;
    }

    public static Geom makeBoxplot() {
        Geom geom = new Geom();
        geom.name = "boxplot";
        geom.defaultStat = "boxplot";
        geom.defaultPosition = "dodge";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("lower");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("upper");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("middle");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.required = false;
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.value = Color.white;
        aes.defaultValue = Color.white;
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.required = false;
        aes.defaultValue = new Double(0.5);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("weight");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("outlier.colour");
        geom.params.add(param);
        param = ParamFactory.makeParam("outlier.shape");
        geom.params.add(param);
        param = ParamFactory.makeParam("outlier.size");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeContour() {
        Geom geom = new Geom();
        geom.name = "contour";
        geom.defaultStat = "contour";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.required = false;
        aes.value = Color.decode("#3366FF");
        aes.defaultValue = Color.decode("#3366FF");
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.required = false;
        aes.defaultValue = new Double(0.5);
        geom.aess.add(aes);
        aes = Aes.makeAes("weight");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("arrow");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeCrossbar() {
        Geom geom = new Geom();
        geom.name = "crossbar";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.value = Color.black;
        aes.defaultValue = Color.black;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("fatten");
        geom.params.add(param);
        param = ParamFactory.makeParam("width");
        param.setTitle("Middle bar width");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeDensity() {
        Geom geom = new Geom();
        geom.name = "density";
        geom.defaultStat = "density";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.value = Color.black;
        aes.defaultValue = Color.black;
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("weight");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.required = false;
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("na.rm");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeDensity2d() {
        Geom geom = new Geom();
        geom.name = "density2d";
        geom.defaultStat = "density2d";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.value = Color.decode("#3366FF");
        aes.defaultValue = Color.decode("#3366FF");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("weight");
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.required = false;
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("na.rm");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeDotPlot() {
        Geom geom = new Geom();
        geom.name = "dotplot";
        geom.defaultStat = "bindot";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y", "", "..count..");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        ParamCharacter paramCharacter = new ParamCharacter("stackdir");
        paramCharacter.setOptions(new String[]{"up", "down", "center", "centerwhole"});
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setDefaultValue("up");
        paramCharacter.setValue("up");
        geom.params.add(paramCharacter);
        ParamNumeric paramNumeric = new ParamNumeric("stackratio");
        paramNumeric.setDefaultValue(1.0);
        paramNumeric.setValue(1.0);
        geom.params.add(paramNumeric);
        paramNumeric = new ParamNumeric("dotsize");
        paramNumeric.setDefaultValue(1.0);
        paramNumeric.setValue(1.0);
        geom.params.add(paramNumeric);
        return geom;
    }

    public static Geom makeErrorbar() {
        Geom geom = new Geom();
        geom.name = "errorbar";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.value = Color.black;
        aes.defaultValue = Color.black;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("width");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeErrorbarh() {
        Geom geom = new Geom();
        geom.name = "errorbarh";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("y");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("x");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("xmin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("xmax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.value = Color.black;
        aes.defaultValue = Color.black;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("width");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeFreqpoly() {
        Geom geom = new Geom();
        geom.name = "freqpoly";
        geom.defaultStat = "bin";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("colour");
        aes.value = Color.black;
        aes.defaultValue = Color.black;
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.required = false;
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeHex() {
        Geom geom = new Geom();
        geom.name = "hex";
        geom.defaultStat = "binhex";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.value = aes.defaultValue = new Color(127, 127, 127);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.required = false;
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeHistogram() {
        Geom geom = new Geom();
        geom.name = "histogram";
        geom.defaultStat = "bin";
        geom.defaultPosition = "stack";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.value = aes.defaultValue = new Color(51, 51, 51);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("weight");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.required = false;
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeHline() {
        Geom geom = new Geom();
        geom.name = "hline";
        geom.defaultStat = "hline";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("colour");
        aes.defaultValue = aes.value = Color.black;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeJitter() {
        Geom geom = new Geom();
        geom.name = "jitter";
        geom.defaultStat = "identity";
        geom.defaultPosition = "jitter";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("shape");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.defaultValue = aes.value = Color.black;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.value = new Double(5.0);
        aes.defaultValue = new Double(5.0);
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("na.rm");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeLine() {
        Geom geom = new Geom();
        geom.name = "line";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.defaultValue = aes.value = Color.black;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("arrow");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeLinerange() {
        Geom geom = new Geom();
        geom.name = "linerange";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("ymin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makePath() {
        Geom geom = new Geom();
        geom.name = "path";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("arrow");
        geom.params.add(param);
        return geom;
    }

    public static Geom makePoint() {
        Geom geom = new Geom();
        geom.name = "point";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("shape");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size", new Double(2.0), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("na.rm");
        geom.params.add(param);
        return geom;
    }

    public static Geom makePointrange() {
        Geom geom = new Geom();
        geom.name = "pointrange";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("ymin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("fill");
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("shape");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        aes.preferNumeric = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makePolygon() {
        Geom geom = new Geom();
        geom.name = "polygon";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        geom.aess.add(aes);
        aes = Aes.makeAes("fill", new Color(51, 51, 51), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeQuantile() {
        Geom geom = new Geom();
        geom.name = "quantile";
        geom.defaultStat = "quantile";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.decode("#3366FF"), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("arrow");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeRaster() {
        Geom geom = new Geom();
        geom.name = "raster";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("fill", new Color(51, 51, 51), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size", new Double(0.1), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        ParamNumeric paramNumeric = new ParamNumeric("hjust");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(1.0));
        paramNumeric.setDefaultValue(0.5);
        paramNumeric.setValue(0.5);
        geom.params.add(paramNumeric);
        paramNumeric = new ParamNumeric("vjust");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(1.0));
        paramNumeric.setDefaultValue(0.5);
        paramNumeric.setValue(0.5);
        geom.params.add(paramNumeric);
        return geom;
    }

    public static Geom makeRect() {
        Geom geom = new Geom();
        geom.name = "rect";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("xmin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("xmax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        geom.aess.add(aes);
        aes = Aes.makeAes("fill", new Color(51, 51, 51), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeRibbon() {
        Geom geom = new Geom();
        geom.name = "ribbon";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("ymin");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("ymax");
        aes.required = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        geom.aess.add(aes);
        aes = Aes.makeAes("fill", new Color(51, 51, 51), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeRug() {
        Geom geom = new Geom();
        geom.name = "rug";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = false;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour");
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeSegment() {
        Geom geom = new Geom();
        geom.name = "segment";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("xend");
        aes.required = true;
        aes.defaultUseVariable = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("yend");
        aes.required = true;
        aes.defaultUseVariable = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("arrow");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeSmooth() {
        Geom geom = new Geom();
        geom.name = "smooth";
        geom.defaultStat = "smooth";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.decode("#3366FF"), null);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("fill", new Color(153, 153, 153), null);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("weight");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha", new Double(0.4), null);
        aes.preferCategorical = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeStep() {
        Geom geom = new Geom();
        geom.name = "step";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha", new Double(0.4), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        Param param = ParamFactory.makeParam("direction");
        geom.params.add(param);
        return geom;
    }

    public static Geom makeText() {
        Geom geom = new Geom();
        geom.name = "text";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("label");
        aes.required = true;
        aes.defaultUseVariable = true;
        aes.useVariable = true;
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size", new Double(5.0), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("angle");
        geom.aess.add(aes);
        aes = Aes.makeAes("hjust");
        geom.aess.add(aes);
        aes = Aes.makeAes("vjust");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha", new Double(0.4), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        ParamLogical paramLogical = new ParamLogical("parse");
        geom.params.add(paramLogical);
        return geom;
    }

    public static Geom makeTile() {
        Geom geom = new Geom();
        geom.name = "tile";
        geom.defaultStat = "identity";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("fill", new Color(51, 51, 51), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size", new Double(0.1), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeViolin() {
        Geom geom = new Geom();
        geom.name = "violin";
        geom.defaultStat = "ydensity";
        geom.defaultPosition = "dodge";
        Aes aes = Aes.makeAes("x");
        geom.aess.add(aes);
        aes = Aes.makeAes("y");
        geom.aess.add(aes);
        aes = Aes.makeAes("colour", new Color(51, 51, 51), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("fill", Color.white, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size", new Double(0.5), null);
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeVline() {
        Geom geom = new Geom();
        geom.name = "vline";
        geom.defaultStat = "vline";
        geom.defaultPosition = "identity";
        Aes aes = Aes.makeAes("colour", Color.black, null);
        geom.aess.add(aes);
        aes = Aes.makeAes("size");
        geom.aess.add(aes);
        aes = Aes.makeAes("linetype");
        geom.aess.add(aes);
        aes = Aes.makeAes("alpha");
        geom.aess.add(aes);
        aes = Aes.makeAes("group");
        geom.aess.add(aes);
        return geom;
    }

    public static Geom makeGeom(String string) {
        if (string == "point") {
            return Geom.makePoint();
        }
        if (string == "abline") {
            return Geom.makeAbline();
        }
        if (string == "area") {
            return Geom.makeArea();
        }
        if (string == "bar") {
            return Geom.makeBar();
        }
        if (string == "bin2d") {
            return Geom.makeBin2d();
        }
        if (string == "blank") {
            return Geom.makeBlank();
        }
        if (string == "boxplot") {
            return Geom.makeBoxplot();
        }
        if (string == "contour") {
            return Geom.makeContour();
        }
        if (string == "crossbar") {
            return Geom.makeCrossbar();
        }
        if (string == "density") {
            return Geom.makeDensity();
        }
        if (string == "density2d") {
            return Geom.makeDensity2d();
        }
        if (string == "dotplot") {
            return Geom.makeDotPlot();
        }
        if (string == "errorbar") {
            return Geom.makeErrorbar();
        }
        if (string == "errorbarh") {
            return Geom.makeErrorbarh();
        }
        if (string == "freqpoly") {
            return Geom.makeFreqpoly();
        }
        if (string == "hex") {
            return Geom.makeHex();
        }
        if (string == "histogram") {
            return Geom.makeHistogram();
        }
        if (string == "hline") {
            return Geom.makeHline();
        }
        if (string == "jitter") {
            return Geom.makeJitter();
        }
        if (string == "line") {
            return Geom.makeLine();
        }
        if (string == "linerange") {
            return Geom.makeLinerange();
        }
        if (string == "path") {
            return Geom.makePath();
        }
        if (string == "pointrange") {
            return Geom.makePointrange();
        }
        if (string == "polygon") {
            return Geom.makePolygon();
        }
        if (string == "quantile") {
            return Geom.makeQuantile();
        }
        if (string == "raster") {
            return Geom.makeRaster();
        }
        if (string == "rect") {
            return Geom.makeRect();
        }
        if (string == "ribbon") {
            return Geom.makeRibbon();
        }
        if (string == "rug") {
            return Geom.makeRug();
        }
        if (string == "segment") {
            return Geom.makeSegment();
        }
        if (string == "smooth") {
            return Geom.makeSmooth();
        }
        if (string == "step") {
            return Geom.makeStep();
        }
        if (string == "text") {
            return Geom.makeText();
        }
        if (string == "tile") {
            return Geom.makeTile();
        }
        if (string == "violin") {
            return Geom.makeViolin();
        }
        if (string == "vline") {
            return Geom.makeVline();
        }
        return null;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("Geom");
            element.setAttribute("className", "org.rosuda.deducer.plots.Geom");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.defaultStat != null) {
                element.setAttribute("defaultStat", this.defaultStat);
            }
            if (this.defaultPosition != null) {
                element.setAttribute("defaultPosition", this.defaultPosition);
            }
            Element element2 = document.createElement("params");
            for (int i = 0; i < this.params.size(); ++i) {
                Element element3 = ((Param)this.params.get(i)).toXML();
                element3 = (Element)document.importNode(element3, true);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
            Element element4 = document.createElement("aess");
            for (int i = 0; i < this.aess.size(); ++i) {
                Element element5 = ((Aes)this.aess.get(i)).toXML();
                element5 = (Element)document.importNode(element5, true);
                element4.appendChild(element5);
            }
            element.appendChild(element4);
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        Object object;
        Element element2;
        int n;
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.Geom")) {
            System.out.println("Error Geom: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.defaultStat = element.hasAttribute("defaultStat") ? element.getAttribute("defaultStat") : null;
        this.defaultPosition = element.hasAttribute("defaultPosition") ? element.getAttribute("defaultPosition") : null;
        Element element3 = (Element)element.getElementsByTagName("params").item(0);
        this.params = new Vector();
        Vector vector = XMLHelper.getChildrenElementsByTag(element3, "Param");
        for (n = 0; n < vector.size(); ++n) {
            element2 = (Element)vector.get(n);
            string = element2.getAttribute("className");
            object = Param.makeParam(string);
            ((Param)object).setFromXML(element2);
            this.params.add(object);
        }
        element3 = (Element)element.getElementsByTagName("aess").item(0);
        this.aess = new Vector();
        vector = XMLHelper.getChildrenElementsByTag(element3, "Aes");
        for (n = 0; n < vector.size(); ++n) {
            element2 = (Element)vector.get(n);
            object = new Aes();
            ((Aes)object).setFromXML(element2);
            this.aess.add(object);
        }
    }
}

