% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.r
\name{estimate.hyper}
\alias{estimate.hyper}
\title{Estimate hyperparameters for model using empirical Bayes.}
\usage{
estimate.hyper(dl, sigma.tau = 0.5, length.scale = NULL,
  model.name = "simplest-model")
}
\arguments{
\item{dl}{de.lorean object}

\item{sigma.tau}{Noise s.d. in temporal dimension, that is prior s.d. for tau}

\item{length.scale}{Length scale for stationary GP covariance function.
Defaults to the range of the observed capture times.}

\item{model.name}{The model's name:
\itemize{
  \item 'simplest-model': The simplest model (does not estimate the gene
    means).
  \item 'simple-model': Like 'simplest-model' but estimates the gene
    means.
  \item 'lowrank': Low rank approximation to the 'simplest-model'.
}}
}
\description{
Estimate hyperparameters for model using empirical Bayes.
}

