% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsListProfiles}
\alias{dsListProfiles}
\title{Get the DataSHIELD profiles}
\usage{
dsListProfiles(conn)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}
}
\value{
A list containing the "available" character vector of profile names and the "current" profile (in case a default one was assigned).
}
\description{
Get the list of DataSHIELD profiles that have been configured on the remote data repository.
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsListProfiles(con)
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRestoreWorkspace}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
