% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DLSSM.R
\name{DLSSM.valid}
\alias{DLSSM.valid}
\title{Dynamical prediction on validation dataset}
\usage{
DLSSM.valid(fit0, data.batched, K)
}
\arguments{
\item{fit0}{Initial fitted model}

\item{data.batched}{Batched dataset generated by function Batched()}

\item{K}{Number of steps for ahead prediction}
}
\value{
\tabular{ll}{
   \code{pred.K:} \tab K-steps ahead predicted coefficients \cr
   \tab \cr
   \code{pred.var.K:} \tab  covariance of K-steps ahead predicted coefficients \cr
   \tab \cr
   \code{pred.prob.K:} \tab  K-steps ahead predicted probabilities \cr
 }
}
\description{
After we have fitted  initial model, we can do validation. It is iteratively doing K-steps ahead prediction and model updating (filtering)
when a new batch of data becomes available.
The validation include K-steps ahead prediction of state vector and probabilities on validation interval.
}
\details{
The argument fit could be object of DLSSM or DLSSM.init.
}
\examples{
\donttest{
set.seed(321)
n=8000
beta0=function(t)   0.1*t-1
beta1=function(t)  cos(2*pi*t)
beta2=function(t)  sin(2*pi*t)
alph1=alph2=1
x=matrix(runif(n*4,min=-4,max=4),nrow=n,ncol=4)
t=sort(runif(n))
coef=cbind(beta0(t),beta1(t),beta2(t),rep(alph1,n),rep(alph2,n))
covar=cbind(rep(1,n),x)
linear=apply(coef*covar,1,sum)
prob=exp(linear)/(1+exp(linear))
y=as.numeric(runif(n)<prob)
sim.data=cbind(y,x,t)
colnames(sim.data)=c("y","x1","x2","x3","x4","t")
formula = y~x1+x2+x3+x4
# Divide the time domain [0,1] into S=100 equally spaced intervals
S=100
S0=75
data.batched=Batched(formula, data=sim.data, time="t", S)

# using first 75 batches as training dataset to tune smoothing parameters
fit0=DLSSM.init(data.batched, S0, vary.effects=c("x1","x2"))
fit0$Lambda

#After initial model fitting on training data, we move to dynamic prediction
 fit=DLSSM.valid(fit0, data.batched, K=1)
 DLSSM.plot(fit)
 }
}
\author{
Jiakun Jiang, Wei Yang and Wensheng Guo
}
