% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{getQuantile}
\alias{getQuantile}
\title{calculate quantiles}
\usage{
getQuantile(simulations, observed, integerResponse, method = c("PIT",
  "traditional"), rotation = NULL)
}
\arguments{
\item{simulations}{a matrix with simulations from a fitted model. Rows = observations, columns = replicate simulations}

\item{observed}{a vector with the observed data}

\item{integerResponse}{is the response integer-valued. Only has an effect for method = "traditional"}

\item{method}{the quantile randomization method used. See details}

\item{rotation}{optional rotation of the residuals, either provided as a covariance matrix, or specify "estimated", in which case the residual covariance will be approximated by simulations. See comments in details}
}
\description{
calculates residual quantiles from a given simulation
}
\details{
The function calculates residual quantiles from the simulated data. For continuous distributions, this will simply the the value of the ecdf.

\strong{Randomization procedure for discrete data}

For discrete data, there are two options implemented.

The current default (available since DHARMa 0.3.1) are probability integral transform (PIT-) residuals (Smith, 1985; Dunn & Smyth, 1996; see also see also Warton, et al., 2017).

Before DHARMa 0.3.1, a different randomization procedure was used, in which the a U(-0.5, 0.5) distribution was added on observations and simulations for discrete distributions. For a completely discrete distribution, the two procedures should deliver equivalent results, but the second method has the disadvantage that a) one has to know if the distribution is discrete (DHARMa tries to recognize this automatically), and b) that it leads to inefficiencies for some distributions such as the the Tweedie, which are partly continuous, partly discrete (see e.g. https://github.com/florianhartig/DHARMa/issues/168).

\strong{Rotation (optional)}

The getQuantile function includes an additional option to rotate residuals. The purpose is to de-correlated residuals in case of residual autocorrelation. If the expected residual autocorrelation is known (e.h. when fitting gls type models), it can be provided as a covariance matrix. If that is note the case, the option "estimated" will try to estimate the covariance from the data simulated by the model. Note, however, that this approximation will tend to have considerable error and may be slow to compute for high-dimensional data.
}
\references{
Smith, J. Q. "Diagnostic checks of non-standard time series models." Journal of Forecasting 4.3 (1985): 283-291.

Dunn, P.K., & Smyth, G.K. (1996). Randomized quantile residuals. Journal of Computational and Graphical Statistics 5, 236-244.

Warton, David I., Loïc Thibaut, and Yi Alice Wang. "The PIT-trap—A “model-free” bootstrap procedure for inference about regression models with discrete, multivariate responses." PloS one 12.7 (2017)
}
