% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_methods.R
\name{read.DeponsDynBatch}
\alias{read.DeponsDynBatch}
\title{Read and merges DEPONS Batchmap and Statistics Files}
\usage{
read.DeponsDynBatch(
  dir,
  par,
  title = "NA",
  landscape = "NA",
  simtime = "NA",
  startday = "NA",
  timestep = 30,
  tz = "UTC"
)
}
\arguments{
\item{dir}{Character string specifying the directory path containing the `Batchmap` and `Statistics` files.}

\item{par}{Character vector specifying the column names to extract from the batch map file for each run.
#' These parameters are then stored in the `Parameters` list.}

\item{title}{Optional character string}

\item{landscape}{Character string. Name of the simulation landscape. Default is "NA".}

\item{simtime}{Optional character string with the date and time when the
simulation finished (format yyyy-mm-dd).}

\item{startday}{The start of the period that the  simulation represents, i.e.
the real-world equivalent of 'tick 1' (character string of the
form 'yyyy-mm-dd', or POSIXlt)}

\item{timestep}{Time step used in the model, in minutes. Defaults to 30 in
DEPONS.}

\item{tz}{Timezone.}
}
\value{
A list of `DeponsDyn` objects and parameter values associated with run id
}
\description{
Reads batch map files and statistics files from a specified directory
and returns a list of `DeponsDyn` objects and parameter values.
}
\examples{
\dontrun{
# Specify the directory containing Batchmap and Statistics files
dir_path <- "path/to/batchdata"

# Specify parameters to extract from Batchmap files
par <- c("parameter1", "parameter2")

# Run the function
results <- read.DeponsBatch(
  dir = dir_path,
  par = par,
  startday = "2010-01-01"
)
}
}
