\name{edcCO2}
\alias{edcCO2}
\docType{data}
\title{EPICA Dome C Ice Core 800KYr Carbon Dioxide Data}
\description{
Carbon dioxide record from the EPICA (European Project for Ice Coring 
in Antarctica) Dome C ice core covering 0 to 800 kyr BP.    
}
\usage{data(edcCO2)}
\format{
  A data frame with 1096 observations on the following 2 variables.
  \describe{
    \item{\code{age}}{Age in years before present (BP)}
    \item{\code{co2}}{CO2 level (ppmv)}
  }
}
\details{
Data are a composite series.
}
\source{
\url{https://www.ncei.noaa.gov/products/paleoclimatology/ice-core}  
}
\references{
Luthi, D., M. et al.  2008.
High-resolution carbon dioxide concentration record 650,000-800,000 
years before present.
Nature, Vol. 453, pp. 379-382, 15 May 2008.  doi:10.1038/nature06949
  
Indermuhle, A., E. et al, 1999, 
Atmospheric CO2 concentration from 60 to 20 kyr BP from the 
Taylor Dome ice core, Antarctica. Geophysical Research Letters, 27, 735-738.

Monnin, E., A. et al. 2001. 
Atmospheric CO2 concentrations over the last glacial termination. 
Science, Vol. 291, pp. 112-114.

Petit, J.R. et al. 1999. 
Climate and atmospheric history of the past 420,000 years from 
the Vostok ice core, Antarctica. 
Nature 399: 429-436.

Siegenthaler, U. et al.  2005. 
Stable Carbon Cycle-Climate Relationship During the Late Pleistocene.
Science, v. 310 , pp. 1313-1317, 25 November 2005.
}
\examples{
data(edcCO2)
}
\keyword{datasets}
