% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcalibrate.R
\name{bcalibrate}
\alias{bcalibrate}
\title{Calibration for Binary Outcomes}
\usage{
bcalibrate(
  y,
  tr,
  t,
  gamma,
  R2 = NULL,
  mu_y_t = NULL,
  mu_u_tr = NULL,
  mu_u_t = NULL,
  cov_u_t = NULL,
  nU = NULL,
  nsim = 4000,
  ...
)
}
\arguments{
\item{y}{\code{data.frame}, \code{matrix} or \code{vector}. Binary outcome variable.}

\item{tr}{\code{data.frame}. Treatment variables with rows corresponding to observations and columns
to variables.}

\item{t}{\code{data.frame}. Treatment arms of interest.
May contain a single or multiple treatments in rows.}

\item{gamma}{a vector specifying the direction of sensitivity parameters.}

\item{R2}{an optional scalar or vector specifying the proportion of residual variance in outcome given the
treatment that can be explained by confounders, which determines the magnitude of sensitivity parameters.}

\item{mu_y_t}{an optional scalar or vector that contains naive estimates of treatment effects
ignoring confounding.}

\item{mu_u_tr}{an optional matrix of conditional confounder means for all observed treatments
with latent variables in columns.}

\item{mu_u_t}{an optional matrix of conditional confounder means for treatments of interest
with latent variables in columns.}

\item{cov_u_t}{an optional covariance matrix of confounders conditional on treatments.}

\item{nU}{Number of latent confounders to consider.}

\item{nsim}{an optional scalar specifying the number of sample draws.}

\item{...}{further arguments passed to \code{\link{kEstimate}}or \code{\link{pca}}.}
}
\value{
A \code{data.frame} with naive and calibrated estimates of population average outcome receiving
treatment \code{t}.
}
\description{
Calibrates the naive estimates to account for unobserved confounding when outcome
variables are binary. The calibration can be done with user-specific sensitivity parameter or
with our pre-provided calibration methods, the worst-case calibration for a single contrast
or multivariate calibration for multiple contrasts.
}
\examples{
\donttest{
# load the example data #
y <- GaussianT_BinaryY$y
tr <- subset(GaussianT_BinaryY, select = -c(y))
t1 <- tr[1:5,]
t2 <- rep(0, times = ncol(tr))
# calibration #
est_b <- bcalibrate(y = y, tr = tr, t = rbind(t1, t2),
                    nU = 3, gamma = c(1.27, -0.28, 0),
                    R2 = c(0.2, 0.7))
est_b_rr <- list(est_df = est_b$est_df[1:5,] / as.numeric(est_b$est_df[6,]),
                 R2 = c(0.2, 0.7))
plot_estimates(est_b_rr)
}
}
