% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSurvival.R
\name{plotSurvival}
\alias{plotSurvival}
\title{Plot survival results}
\usage{
plotSurvival(
  result,
  ribbon = TRUE,
  facet = NULL,
  colour = NULL,
  cumulativeFailure = FALSE,
  riskTable = FALSE,
  riskInterval = 30,
  logLog = FALSE,
  timeScale = "days"
)
}
\arguments{
\item{result}{Survival results}

\item{ribbon}{If TRUE, the plot will join points using a ribbon}

\item{facet}{Variables to use for facets}

\item{colour}{Variables to use for colours}

\item{cumulativeFailure}{whether to plot the cumulative failure probability
instead of the survival probability}

\item{riskTable}{Whether to print risk table below the plot}

\item{riskInterval}{Interval of time to print risk table below the plot}

\item{logLog}{If TRUE, the survival probabilities are transformed using the log-log formula}

\item{timeScale}{The scale of time in the x-axis. Can be "days", "months", or "years"}
}
\value{
A plot of survival probabilities over time
}
\description{
Plot survival results
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(cdm,
                                    targetCohortTable = "mgus_diagnosis",
                                    outcomeCohortTable = "death_cohort")
plotSurvival(surv)
}

}
