% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exitAtColumnDate.R
\name{exitAtFirstDate}
\alias{exitAtFirstDate}
\title{Set cohort end date to the first of a set of column dates}
\usage{
exitAtFirstDate(
  cohort,
  dateColumns,
  cohortId = NULL,
  returnReason = TRUE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{dateColumns}{Date columns in the cohort table to consider.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{returnReason}{If TRUE it will return a column stating which column in
\code{dateColumns} is used as a new cohort end date.}

\item{name}{Name of the new cohort with the restriction.}
}
\value{
The cohort table.
}
\description{
\code{exitAtFirstDate()} resets cohort end date based on a set of specified
column dates. The first date that occurs is chosen.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor(tables = list(
"cohort" = dplyr::tibble(
  cohort_definition_id = 1,
  subject_id = c(1, 2, 3, 4),
  cohort_start_date = as.Date(c("2000-06-03", "2000-01-01", "2015-01-15", "2000-12-09")),
  cohort_end_date = as.Date(c("2001-09-01", "2001-01-12", "2015-02-15", "2002-12-09")),
  date_1 = as.Date(c("2001-08-01", "2001-01-01", "2015-01-15", "2002-12-09")),
  date_2 = as.Date(c("2001-08-01", NA, "2015-04-15", "2002-12-09"))
)
))
cdm$cohort |> exitAtFirstDate(dateColumns = c("date_1", "date_2"))
}
}
