% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicesclusters.R
\name{indicesClusters}
\alias{indicesClusters}
\title{Compute the indices to evaluate the quality of the cluster partition in multi-block context}
\usage{
indicesClusters(Data, Blocks, cut, NameBlocks=NULL, center=TRUE, scale=FALSE)
}
\arguments{
\item{Data}{data frame or matrix. Correspond to all the blocks of variables merged horizontally}

\item{Blocks}{numerical vector. The number of variables of each block. The sum must be equal to the number of columns of Data.}

\item{cut}{numerical vector. The partition of the cluster analysis.}

\item{NameBlocks}{string vector. Name of each block. Length must be equal to the length of Blocks vector. If NULL, the names are B1,...Bm. Default: NULL}

\item{center}{logical. Should the data variables be centered? Default: TRUE. Please set to FALSE for a CATA experiment}

\item{scale}{logical. Should the data variables be scaled? Default: FALSE}
}
\value{
\itemize{
         \item Il: the Il indices
         \item jl: the jl indicess
         }
}
\description{
Compute the Il index to evaluate the agreement between each block and the global partition (in sensory: agreement between each subject and the global partition)

Compute the Jl index to evaluate if each block has a partition (in sensory: if each subject made a partition of products)
}
\examples{

#####projective mapping####
library(ClustBlock)
data(smoo)
res1=ClusMB(smoo, rep(2,24))
summary(res1)
indicesClusters(smoo, rep(2,24), res1$group)

####CATA####
data(fish)
Data=fish[1:66,2:30]
chang2=change_cata_format2(Data, nprod= 6, nattr= 27, nsub = 11, nsess= 1)
res2=ClusMB(Data= chang2$Datafinal, Blocks= rep(27, 11), center=FALSE)
indicesClusters(Data= chang2$Datafinal, Blocks= rep(27, 11),cut = res2$group, center=FALSE)

}
\references{
Llobell, F., Qannari, E.M. (June 10, 2022). Cluster analysis in a multi-bloc setting. SMTDA, Athens, Greece.\cr
Llobell, F., Giacalone, D., Qannari, E. M. (Pangborn 2021). Cluster Analysis of products in CATA experiments.\cr
Paper submitted
}
\seealso{
\code{\link{clustRowsOnStatisAxes}}, , \code{\link{ClusMB}}
}
\keyword{CATA}
\keyword{RATA}
\keyword{quantitative}
