% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.desc.R
\name{split.desc}
\alias{split.desc}
\title{Split method for desc object}
\usage{
\method{split}{desc}(x, f, drop, ..., variable, at)
}
\arguments{
\item{x}{A desc object}

\item{f}{see split documentation}

\item{drop}{see split documentation}

\item{...}{Other parameters}

\item{variable}{Character. Indicates the variable to use for the split}

\item{at}{Integer. Indicates the maximum number of levels to include in the first splitted table}
}
\description{
Split method for desc object
}
\details{
Used for splitting an output in two. It can be used when the table
takes too much space in a page of a Word document (see the example below).
}
\examples{

data(data)

tab1=report.quanti(data=data,y="y_numeric",
	x1="GROUP",x2="TIMEPOINT",at.row="TIMEPOINT",subjid="SUBJID")


s=split(tab1,variable="TIMEPOINT",at=3)

tab1.1=s$x1
tab1.2=s$x2

tab1.1
tab1.2 

}
\seealso{
\code{\link{desc}}
}
