% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv_est.R
\name{iv_est}
\alias{iv_est}
\title{Standard Instrumental Variable Estimator}
\usage{
iv_est(IV, data, n.boot = 50)
}
\arguments{
\item{IV}{the instrumental variable to be used in the conditional means. Must be a factor with no more than 2 levels.
It is assumed the second level is the positive level, i.e., the binary equivalent of the second factor level should be 1
and the first should be 0.}

\item{data}{a data frame containing the variables in the model.
This should be the same data used in \code{\link[=init_params]{init_params}}.}

\item{n.boot}{an integer value that indicates number of bootstrap iterations to calculate standard error.}
}
\value{
\code{iv_est} returns a data frame containing the standard IV estimate, standard error, and Wald 95% CI.
}
\description{
`iv_est` calculates the standard IV estimand using the conditional means on a given instrumental variable.
}
\examples{
library(causaldata)
data(nhefs)
nhefs.nmv <- nhefs[which(!is.na(nhefs$wt82)), ]
nhefs.nmv$qsmk <- as.factor(nhefs.nmv$qsmk)

confounders <- c(
  "sex", "race", "age", "education", "smokeintensity",
  "smokeyrs", "exercise", "active", "wt71"
)
nhefs.iv <- nhefs[which(!is.na(nhefs$wt82) & !is.na(nhefs$price82)), ]
nhefs.iv$highprice <- as.factor(ifelse(nhefs.iv$price82 >= 1.5, 1, 0))
nhefs.iv$qsmk <- as.factor(nhefs.iv$qsmk)
init_params(wt82_71, qsmk,
            covariates = confounders,
            data = nhefs.iv)

iv_est("highprice", nhefs.iv)
}
