#' @title Auxiliary function for the log-likelihood estimation of CUBE models with covariates
#' @aliases Qdue
#' @description Define the opposite of one of the two scalar functions that are maximized when running the E-M 
#' algorithm for CUBE models with covariates for feeling, uncertainty and overdispersion.
#' @keywords internal 
#' @usage Qdue(param, esterno2, q, m)
#' @param param Vector of initial estimates of parameters for the feeling component and the overdispersion effect
#' @param esterno2 Matrix binding together the column vector of the posterior probabilities that each observed rating
#'  has been generated by the distribution of the first component of the mixture, the column vector of ordinal responses, 
#' and the matrices W and Z of the selected covariates for feeling and overdispersion, respectively
#' @param q Number of selected covariates for explaining the feeling component
#' @param m Number of ordinal categories
#' @details It is iteratively called as an argument of "optim" within CUBE function (with covariates) as  the function to minimize 
#' to compute the maximum likelihood estimates for the feeling and the overdispersion components. 

Qdue <-
function(param,esterno2,q,m){
  v<-ncol(esterno2)-q-2
  tauno<-esterno2[,1]
  ordinal<-esterno2[,2]
  W<-esterno2[,3:(q+2)]
  Z<-esterno2[,(q+3):ncol(esterno2)]
  gama<-param[1:(q+1)]
  alpha<-param[(q+2):(q+v+2)]
  csi<-logis(W,gama)   
  phi<-1/(-1 + 1/logis(Z,alpha)) 
  betabin<-betabinomial(m,ordinal,csi,phi)
  return(-sum(tauno*log(betabin)))           ### change sign for optim
}
