% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.GEM}
\alias{summary.GEM}
\title{S3 method: summary for class "GEM"}
\usage{
\method{summary}{GEM}(object, correlation = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{\link{GEM}}}

\item{correlation}{Logical: should the estimated correlation matrix be returned? Default is FALSE}

\item{...}{Other arguments}
}
\value{
Extended summary results of the fitting procedure, including parameter estimates, their standard errors and
Wald statistics, maximized log-likelihood compared with that of the saturated model and of a Uniform sample.
AIC, BIC and ICOMP indeces are also displayed for model selection. Execution time and number of exectued iterations 
for the fitting procedure are aslo returned.
}
\description{
S3 method summary for objects of class \code{\link{GEM}}.
}
\examples{
model<-GEM(Formula(MeetRelatives~0|0|0),family="cube",data=relgoods) 
summary(model,correlation=TRUE,digits=4)

}
\keyword{package}
