% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUB.R
\name{CUB}
\alias{CUB}
\title{Main function for CUB models}
\usage{
CUB(Formula, data, ...)
}
\arguments{
\item{Formula}{Object of class Formula.}

\item{data}{Data frame from which model matrices and response variables are taken.}

\item{...}{Additional arguments to be passed for the specification of the model, including covariates matrices Y, W, X for 
#' for uncertainty, feeling and shelter, respectively.}
}
\value{
An object of the class "GEM"-CUB": returns a list containing the following results: 
\item{estimates}{Maximum likelihood estimates: \eqn{(\pi, \xi)}}
\item{loglik}{Log-likelihood function at the final estimates}
\item{varmat}{Variance-covariance matrix of final estimates}
\item{niter}{Number of executed iterations}
\item{BIC}{BIC index for the estimated model}
}
\description{
Main function to estimate and validate a CUB model for explaining uncertainty 
and feeling for given ratings, with or without covariates and shelter effect.
}
\details{
This is the main function for CUB models, which calls for the corresponding functions whenever 
covariates or shelter effect are specified. It performs maximum likelihood estimation via the E-M algorithm 
for CUB models and extensions. The optimization procedure is run via "optim".\cr
It is possible to fit data with CUB models, with or without covariates 
for the parameters of the mixture model, and CUB models with shelter effect with no covariate included 
in the model. The program also checks if the estimated variance-covariance matrix is positive definite: 
if not, it prints a warning message and returns a matrix and related results with NA entries.
}
\examples{
\donttest{
data(relgoods)
ordinal<-na.omit(relgoods[,40]) 
model<-CUB(ordinal)     
estpar<-model$estimates  # Estimated parameter vector (pai,csi)
maxlik<-model$loglik     # Log-likelihood function at ML estimates
vmat<-model$varmat
nniter<-model$niter
BICCUB<-model$BIC
################
## CUB model with shelter effect
data(univer)
officeho<-univer[,10]
model<-CUB(officeho,shelter=7)
BICcub<-model$BIC
################
## CUB model with covariates for all components - GeCub
data(univer)
officeho<-univer[,10]
gender<-relgoods[,7]
model<-CUB(officeho,shelter=7,Y=gender,W=gender,X=gender)
BICcub<-model$BIC
################
## CUB model with covariate for uncertainty
data(relgoods)
ordinal<-relgoods[,26] 
gender<-relgoods[,7]
data<-na.omit(cbind(ordinal,gender))
modelcovpai<-CUB(data[,1],Y=data[,2])
BICcovpai<-modelcovpai$BIC
## CUB model with covariate for feeling
data(univer)
ordinal<-univer[,12]
freqserv<-univer[,2]
modelcovcsi<-CUB(ordinal,W=freqserv)
##################
## CUB model with covariates for both components
data(univer)
gender<-univer[,4]
lage<-log(univer[,3])-mean(log(univer[,3]))
ordinal<-univer[,12]
maxiter<-500; toler<-1e-6;
model<-CUB(ordinal,Y=gender,W=lage) 
param<-model$estimates
bet<-param[1:2]      # ML estimates of coefficients for uncertainty covariate
gama<-param[3:4]     # ML estimates of coefficients for feeling covariate
}
}
\references{
Piccolo D. and D'Elia A. (2008). A new approach for modelling consumers' preferences, \emph{Food Quality and Preference},
\bold{18}, 247--259 \cr
Iannario M. and Piccolo D. (2012). CUB models: Statistical methods and empirical evidence, in: 
Kenett R. S. and Salini S. (eds.), \emph{Modern Analysis of Customer Surveys: with applications using R}, 
J. Wiley and Sons, Chichester, 231--258\cr
Iannario M. (2012). Modelling \emph{shelter} choices in a class of mixture models for ordinal responses,  
\emph{Statistical Methods and Applications}, \bold{21}, 1--22 \cr
Iannario M. and Piccolo D. (2014). Inference for CUB models: a program in R, \emph{Statistica & Applicazioni}, 
\bold{XII} n.2, 177--204 \cr
Iannario M. (2016). Testing the overdispersion parameter in CUBE models,
 \emph{Communications in Statistics: Simulation and Computation}, \bold{45}(5), 1621--1635
}
\seealso{
\code{\link{probcub00}}, \code{\link{probcubp0}}, \code{\link{probcub0q}}, \code{\link{probcubpq}},
\code{\link{probcubshe1}}, \code{\link{loglikCUB}}, \code{\link{varmatCUB}}
}
\keyword{internal}

